/**
 * Copyright (c) 2021-2025, RnD Center «ELVEES», JSC
 * All rights reserved.
 * Contacts: https://elvees.ru, support@elvees.com
 *
 * Project:		SDK
 *
 * SPDX-License-Identifier: BSD-3-Clause
 *
 *
 * Разрешается повторное распространение и использование как в виде исходного кода, так и в объектном коде, 
 * с изменениями или без, при соблюдении следующих условий:
 * 
 * 1. При повторном распространении исходного кода должно оставаться указанное выше уведомление об авторском праве, 
 * этот список условий и последующий отказ от гарантий.
 * 2. При повторном распространении двоичного кода должна сохраняться указанная выше информация об авторском праве, 
 * этот список условий и последующий отказ от гарантий в документации и/или в других материалах, поставляемых при 
 * распространении.
 * 3. Ни название организации, ни имена её сотрудников не могут быть использованы в качестве поддержки или 
 * продвижения продуктов, основанных на этом ПО без предварительного письменного разрешения.
 * ЭТА ПРОГРАММА ПРЕДОСТАВЛЕНА ВЛАДЕЛЬЦАМИ АВТОРСКИХ ПРАВ И/ИЛИ ДРУГИМИ СТОРОНАМИ «КАК ОНА ЕСТЬ» 
 * БЕЗ КАКОГО-ЛИБО ВИДА ГАРАНТИЙ, ВЫРАЖЕННЫХ ЯВНО ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ИМИ, 
 * ПОДРАЗУМЕВАЕМЫЕ ГАРАНТИИ КОММЕРЧЕСКОЙ ЦЕННОСТИ И ПРИГОДНОСТИ ДЛЯ КОНКРЕТНОЙ ЦЕЛИ. НИ В КОЕМ СЛУЧАЕ 
 * НИ ОДИН ВЛАДЕЛЕЦ АВТОРСКИХ ПРАВ И НИ ОДНО ДРУГОЕ ЛИЦО, КОТОРОЕ МОЖЕТ ИЗМЕНЯТЬ И/ИЛИ ПОВТОРНО 
 * РАСПРОСТРАНЯТЬ ПРОГРАММУ, КАК БЫЛО СКАЗАНО ВЫШЕ, НЕ НЕСЁТ ОТВЕТСТВЕННОСТИ, ВКЛЮЧАЯ ЛЮБЫЕ ОБЩИЕ, 
 * СЛУЧАЙНЫЕ, СПЕЦИАЛЬНЫЕ ИЛИ ПОСЛЕДОВАВШИЕ УБЫТКИ, ВСЛЕДСТВИЕ ИСПОЛЬЗОВАНИЯ ИЛИ НЕВОЗМОЖНОСТИ ИСПОЛЬЗОВАНИЯ ПРОГРАММЫ 
 * (ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ПОТЕРЕЙ ДАННЫХ, ИЛИ ДАННЫМИ, СТАВШИМИ НЕПРАВИЛЬНЫМИ, ИЛИ ПОТЕРЯМИ, 
 * ПРИНЕСЕННЫМИ ИЗ-ЗА ВАС ИЛИ ТРЕТЬИХ ЛИЦ, ИЛИ ОТКАЗОМ ПРОГРАММЫ РАБОТАТЬ СОВМЕСТНО С ДРУГИМИ ПРОГРАММАМИ), 
 * ДАЖЕ ЕСЛИ ТАКОЙ ВЛАДЕЛЕЦ ИЛИ ДРУГОЕ ЛИЦО БЫЛИ ИЗВЕЩЕНЫ О ВОЗМОЖНОСТИ ТАКИХ УБЫТКОВ.
 *
 *
 * Redistribution and use in source and binary forms, with or without modification, are permitted provided 
 * that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this list of conditions 
 * and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions 
 * and the following disclaimer in the documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the copyright holder nor the names of its contributors may be used to endorse 
 * or promote products derived from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, 
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED 
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */




#include "eliot1_board.h"
#include "hal_spi.h"
#include "spi_adc.h"

enum spi_status SPI_AdcInit(SPI_Type *base, uint32_t spi_frequency)
{
    spi_config_t user_cfg  = {0};
    enum spi_status status = SPI_Status_Ok;

    /* Установка выводов в функцию SPI. */
    GPIO_PinMode_Function(GPIO_SPI1_SCK,  GPIO_ALT_FUNC_SPI0_SPI1);
    GPIO_PinMode_Function(GPIO_SPI1_MOSI, GPIO_ALT_FUNC_SPI0_SPI1);
    GPIO_PinMode_Function(GPIO_SPI1_MISO, GPIO_ALT_FUNC_SPI0_SPI1);

    /* Конфигурация GPIO для SPI1_SS */
    GPIO_PinMode_GPIO(GPIO_SPI1_SS, GPIO_DigitalOutput);
    GPIO_PinWrite(GPIO_SPI1_SS, 1);

    /* Инициализация SPI. */
    SPI_MasterGetDefaultConfig(&user_cfg);
    /*
     * user_cfg.master.loopback_enable = false;
     * user_cfg.master.baud_rate_bps = 500000U;
     * user_cfg.data_width_bits = SPI_Data8Bits;
     * user_cfg.direction = SPI_ShiftDirMsbFirst;
     * user_cfg.enable = true;
     * user_cfg.frame_format = SPI_FfMotorola;
     * user_cfg.motorola_cfg.clk_pol = SPI_MotorolaClkPolLow;
     * user_cfg.motorola_cfg.cap_data = SPI_MotorolaCapDataRising;
     */
    user_cfg.master.baud_rate_bps = spi_frequency;
    status = SPI_MasterInit(base, &user_cfg, CLKCTR_GetSysClk(CLOCK_BASE));

    return status;
}

enum spi_status SPI_DuplexTransfer(SPI_Type *base, uint8_t *src_buffer,
    uint8_t *dest_buffer, int32_t len)
{
    enum spi_status status  = SPI_Status_Ok;

    spi_transfer_t xfer = {0};
    xfer.tx_data        = src_buffer;
    xfer.rx_data        = dest_buffer;
    xfer.data_size      = len;

    /* Блокирующая дуплексная передача данных (с ожиданием завершения операции). */
    GPIO_PinWrite(GPIO_SPI1_SS, 0);
    status = SPI_MasterTransferBlocking(base, &xfer);
    GPIO_PinWrite(GPIO_SPI1_SS, 1);

    return status;
}

enum spi_status SPI_HalfDuplexTransfer(SPI_Type *base, uint8_t *src_buffer,
    uint8_t *dest_buffer, int32_t len_src, int32_t len_dest, bool is_transmit_first)
{
    UNUSED(is_transmit_first);

    enum spi_status status  = SPI_Status_Ok;

    spi_half_duplex_transfer_t xfer;
    xfer.rx_data           = dest_buffer;
    xfer.rx_data_size      = len_src;
    xfer.tx_data           = src_buffer;
    xfer.tx_data_size      = len_dest;

    /* Блокирующая полудуплексная передача данных (с ожиданием завершения операции). */
    GPIO_PinWrite(GPIO_SPI1_SS, 0);
    status = SPI_MasterHalfDuplexTransferBlocking(base, &xfer);
    GPIO_PinWrite(GPIO_SPI1_SS, 1);

    return status;
}
