# Обзор

Пример демонстрирует работу функций драйвера Flash (WriteWord и Erase), которые используются в проекте в виде blob-функций.

## Описание программы

Пример инициализирует FLASH-контроллер, стирает, записывает и вычитывает заданные данные
в последних страницах основной и системной области FLASH-памяти. Программа собирается по адресам FLASH-памяти.
В примере используются заранее скомпилированные функции WriteWord и Erase.

## Необходимый Toolchain

- Embedded GCC ARM 10.3.1.

## Требования к аппаратному обеспечению для запуска примера

Перечень аппаратного обеспечения для запуска теста представлен ниже.

- USB Type-C кабель.
- плата ELIOT1m\_MO.
- персональный компьютер.
- mini USB кабель.
- переходник USB-UART.

## Работа с программой

- Добавить путь до **arm toolchain** в переменную **PATH**.
- Вызвать скрипт **build.sh**.
- Выполнить команду `arm-none-eabi-gdb-py -x eliot1.gdbinit` для загрузки
  программы на плату, находясь в директории `armgcc` текущего примера.
- Запустить программу на исполнение с помощью gdb команды `continue`.

## Настройки платы

Настройки пинов:

| Pin Name | Board Location |
| ------ | ------ |
| UART0_TXD | GPIO_PA0 / D1 |
| UART0_RXD | GPIO_PA1 / D0 |
| UART0_GND | GND |

## Подготовка к работе

Процесс запуска на плате.

1. Подключите плату.
2. Откройте последовательный терминал (пример Putty, Minicom) со следующими настройками:
    - скорость 115200 бод;
    - 8 бит данных;
    - нет паритета;
    - один стоповый бит;
    - нет контроля потока.
3. Запустите программу с помощью gdb-отладчика.

## Вывод программы после запуска

При успешном запуске на терминале сразу отразится вывод:

```bash
Board CFG: FCLK : 150MHz, SysCLK : 50MHz, VCore 1.10v (DC-DC vlv2), T = 33.50°C
FLASH : Flash example start
FLASH : Flash main region write/read...
FLASH : Flash system region write/read...
FLASH : Flash example end
```
