/**
 * Copyright (c) 2021-2025, RnD Center «ELVEES», JSC
 * All rights reserved.
 * Contacts: https://elvees.ru, support@elvees.com
 *
 * Project:		SDK
 *
 * SPDX-License-Identifier: BSD-3-Clause
 *
 *
 * Разрешается повторное распространение и использование как в виде исходного кода, так и в объектном коде, 
 * с изменениями или без, при соблюдении следующих условий:
 * 
 * 1. При повторном распространении исходного кода должно оставаться указанное выше уведомление об авторском праве, 
 * этот список условий и последующий отказ от гарантий.
 * 2. При повторном распространении двоичного кода должна сохраняться указанная выше информация об авторском праве, 
 * этот список условий и последующий отказ от гарантий в документации и/или в других материалах, поставляемых при 
 * распространении.
 * 3. Ни название организации, ни имена её сотрудников не могут быть использованы в качестве поддержки или 
 * продвижения продуктов, основанных на этом ПО без предварительного письменного разрешения.
 * ЭТА ПРОГРАММА ПРЕДОСТАВЛЕНА ВЛАДЕЛЬЦАМИ АВТОРСКИХ ПРАВ И/ИЛИ ДРУГИМИ СТОРОНАМИ «КАК ОНА ЕСТЬ» 
 * БЕЗ КАКОГО-ЛИБО ВИДА ГАРАНТИЙ, ВЫРАЖЕННЫХ ЯВНО ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ИМИ, 
 * ПОДРАЗУМЕВАЕМЫЕ ГАРАНТИИ КОММЕРЧЕСКОЙ ЦЕННОСТИ И ПРИГОДНОСТИ ДЛЯ КОНКРЕТНОЙ ЦЕЛИ. НИ В КОЕМ СЛУЧАЕ 
 * НИ ОДИН ВЛАДЕЛЕЦ АВТОРСКИХ ПРАВ И НИ ОДНО ДРУГОЕ ЛИЦО, КОТОРОЕ МОЖЕТ ИЗМЕНЯТЬ И/ИЛИ ПОВТОРНО 
 * РАСПРОСТРАНЯТЬ ПРОГРАММУ, КАК БЫЛО СКАЗАНО ВЫШЕ, НЕ НЕСЁТ ОТВЕТСТВЕННОСТИ, ВКЛЮЧАЯ ЛЮБЫЕ ОБЩИЕ, 
 * СЛУЧАЙНЫЕ, СПЕЦИАЛЬНЫЕ ИЛИ ПОСЛЕДОВАВШИЕ УБЫТКИ, ВСЛЕДСТВИЕ ИСПОЛЬЗОВАНИЯ ИЛИ НЕВОЗМОЖНОСТИ ИСПОЛЬЗОВАНИЯ ПРОГРАММЫ 
 * (ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ПОТЕРЕЙ ДАННЫХ, ИЛИ ДАННЫМИ, СТАВШИМИ НЕПРАВИЛЬНЫМИ, ИЛИ ПОТЕРЯМИ, 
 * ПРИНЕСЕННЫМИ ИЗ-ЗА ВАС ИЛИ ТРЕТЬИХ ЛИЦ, ИЛИ ОТКАЗОМ ПРОГРАММЫ РАБОТАТЬ СОВМЕСТНО С ДРУГИМИ ПРОГРАММАМИ), 
 * ДАЖЕ ЕСЛИ ТАКОЙ ВЛАДЕЛЕЦ ИЛИ ДРУГОЕ ЛИЦО БЫЛИ ИЗВЕЩЕНЫ О ВОЗМОЖНОСТИ ТАКИХ УБЫТКОВ.
 *
 *
 * Redistribution and use in source and binary forms, with or without modification, are permitted provided 
 * that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this list of conditions 
 * and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions 
 * and the following disclaimer in the documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the copyright holder nor the names of its contributors may be used to endorse 
 * or promote products derived from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, 
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED 
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */




#include "eliot1_board.h"

#include "hal_flash.h"

uint32_t start_address_main = (FLASH_MAIN_REGION_SIZE_IN_BYTE
            - FLASH_PAGE_SIZE_IN_BYTE);

uint32_t start_address_system = (FLASH_SystemRegion
    + FLASH_SYSTEM_REGION_SIZE_IN_BYTE - FLASH_PAGE_SIZE_IN_BYTE)
    | FLASH_SECURE_MODE;

uint32_t patterns[] = {
    0x00000000,
    0x55555555,
    0xaaaaaaaa,
};

uint8_t data_wr[FLASH_PAGE_SIZE_IN_BYTE] = {0};

enum flash_status FLASH_TestPatternWriteRead(enum flash_region region)
{
    uint32_t err_data = 0;
    uint32_t address = 0, err_address = 0;

    FCTR_Type *base = (region == FLASH_MainRegion) ? FCTR : FCTR_Secure;

    uint32_t start_address = (region == FLASH_MainRegion) ?
        start_address_main : start_address_system;

    enum flash_status status = FLASH_Status_Ok;

    for (uint32_t pattern_i = 0; pattern_i < DIM(patterns); pattern_i++) {
        memset(data_wr, patterns[pattern_i], FLASH_PAGE_SIZE_IN_BYTE);

        status = FLASH_Erase(base, (uint32_t *)(start_address & FLASH_ADDR_Msk),
            FLASH_PAGE_SIZE_IN_BYTE);
        if (status != FLASH_Status_Ok) {
            printf("FLASH: FAILED on erase: %d\r\n", status);
            return status;
        }

        status = FLASH_VerifyErase((uint32_t *)start_address,
            FLASH_PAGE_SIZE_IN_BYTE);
        if (status != FLASH_Status_Ok) {
            printf("FLASH: FAILED on verify erasure: %d\r\n", status);
            return status;
        }

        address = start_address;
        status = FLASH_Program(base, (uint32_t *)address, (uint32_t *)data_wr,
            FLASH_PAGE_SIZE_IN_BYTE);
        if (status != FLASH_Status_Ok) {
            printf("FLASH: FAILED on program pattern %lx, driver returned status: %d\r\n",
                patterns[pattern_i], status);
            return status;
        }

        address = start_address;
        status = FLASH_VerifyProgram((uint32_t *)address, FLASH_PAGE_SIZE_IN_BYTE,
            (uint32_t *)data_wr, &err_address, &err_data);
        if (status != FLASH_Status_Ok) {
            printf("FLASH: FAILED on verify pattern: 0x%lx, *(0x%08lx): 0x%lx\r\n",
                patterns[pattern_i], err_address, err_data);
            return status;
        }
    }

    return status;
}

int main(void)
{
    enum flash_status status;

    BOARD_InitAll();

    printf("FLASH : Flash example start\r\n");

    status = FLASH_Init(FCTR_Secure);
    if (status != FLASH_Status_Ok) {
        printf("FLASH : flash controller init failed\r\n");
        return 1;
    }

    printf("FLASH : Flash main region write/read...\r\n");
    status = FLASH_TestPatternWriteRead(FLASH_MainRegion);
    if (status != FLASH_Status_Ok) {
        printf("FLASH : failed to check Main region\r\n");
        return 1;
    }

    printf("FLASH : Flash system region write/read...\r\n");
    status = FLASH_TestPatternWriteRead(FLASH_SystemRegion);
    if (status != FLASH_Status_Ok) {
        printf("FLASH : failed to check System region\r\n");
        return 1;
    }

    printf("FLASH : Flash example end\r\n");

    asm volatile("bkpt");

    return 0;
}
