# Обзор

Пример для qspi.

## Краткое описание

Тест контроллера QSPI микросхемы Eliot-01m(1892ВМ268) в составе модуля ELIOT1m\_MO.

## Назначение

Проверка корректности функционирования контроллера QSPI.

## Требования к оборудованию

- кабель Type-C USB;
- плата ELIoT1m\_MO;
- персональный компьютер.

## Описание алгоритма теста

ELF-файл, собранный в адресах внутренней памяти микросхемы Eliot-01, загружается
в память процессора с помощью отладчика `arm-none-eabi-gdb-py`.

### Этапы теста

Тест состоит из этапов:

1. Инициализация драйвера, чтение таблицы SFDP, инициализация DMA.
2. Очистка всей микросхемы флеш-памяти.
3. Программирование стартовой страницы инкрементом.
4. Верификация программирования в режиме XIP.
5. Очистка стартового сектора.
6. Верификация очистки чтением с DMA.
7. Замер времени исполнения функции в режиме XIP и сравнение с временем
   исполнения в памятях RAM и FLASH.
8. Замер скорости чтения в XIP при частоте QSPI 100МГц.

## Вызов программы тестирования

```bash
arm-none-eabi-gdb-py -x eliot1.gdbinit
```

## Вызов программы монитора последовательного порта на ПК

### Команда вызова

```bash
minicom -D /dev/ttyUSBx
```

### Настройки порта

```bash
- Bps 115200
- Par N
- Stop Bits 1
```

## Примерный вывод программы

```bash
Test started...
QSPI NOR init completed
Chip erasing...
Chip erase completed
Page program completed
Page program verification completed
Block erase completed
Block erase verification completed
SUM = 2547154496 Time :: 1400005 mks (from RAM)
SUM = 2547154496 Time :: 1400005 mks (from FLASH)
SUM = 2547154496 Time :: 1400007 mks (from XIP)
QSPI 100MHz testing...
Data transfer rate: 19.604768 MB/s
Speed read verification completed
Test finished
```
