# Обзор

Пример демонстрирует подключение CLI и реализацию простых команд.

## Описание примера

Пример реализации командной консоли Embedded CLI с небольшим набором заложенных команд, среди которых:

- `cpuinfo` - вывод системной информации о ЦП;
- `help` - вывод списка доступных команд;
- `reboot` - перезагрузка процессора через сброс WDT-счетчика с таймаутом на 0.5 с;
- `settime` - установка времени/даты RWC модуля;
- `timenow` - вывод текущих времени/даты RWC модуля;
- `whoami` - вывод наименование платы.


## Необходимый Toolchain

- Embedded GCC ARM 10.3.1
- Последовательный терминал (Putty, Minicom)

## Требования к аппаратному обеспечению для запуска примера

- Type-C кабель
- Плата с ELIOT1m\_MO
- Персональный компьютер
- Переходник USB-UART

## Работа с программой

1. Подключиться к UART
2. В каталоге `/middleware/embeddedcli/src/lib/` исполнить скрипт:

```
python build-shl.py
```

3. В каталоге `/boards/eliot1m_mo/feature_examples/embedded_cli/uart_embedded_cli/cm33_core0/armgcc/` исполнить скрипт:

```
bash build.sh
```

4. После сборки примера исполнить скрипт **load.sh** для загрузки
  программы на плату
5. Запустить программу на исполнение с помощью gdb команды `continue`

## Настройки платы

Дополнительная настройка выходов и перемычек не требуется.

## Подготовка к работе

1. Подключитесь к UART
2. Откройте последовательный терминал (пример Putty, Minicom) со следующими
   настройками:
   - скорость 115200 бод;
   - 8 бит данных;
   - нет паритета;
   - один стоповый бит;
   - нет контроля потока.

## Вывод программы после запуска

При успешном запуске будет отображаться на терминале:

```bash
    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Board CFG: FCLK : 150MHz, SysCLK : 50MHz, VCore 1.10v (DC-DC vlv2), T = 31.50C
ELIOT01M-MO UART Embedded CLI example                                           
CLI was started. Enter your commands                                            
Use command help to see all commands are available                              
> 
    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
```

Введите на клавиатуре команду help, а затем нажмите кнопку Enter, чтобы увидеть список доступных команд.
