# Обзор

Пример определяет класс объекта на основе метода наивной байесовой классификации.

## Описание примера

Программа использует обучающие данные (рассчитанные медиану и среднеквадратичное
отклонение уже готовой выборки) для оценки параметров вероятностного распределения, а затем определяет класс объекта по его параметрам.

## Необходимый Toolchain

- Embedded GCC ARM 10.3.1.

## Требования к аппаратному обеспечению для запуска примера

- Type-C USB кабель;
- плата ELIOT1M_MO;
- персональный компьютер.

## Подготовка к работе

1. Подключить все.
2. Открыть последовательный терминал (пример Putty, Minicom) со следующи настройками:
   - скорость 115200 бод;
   - 8 бит данных;
   - нет паритета;
   - один стоповый бит;
   - нет контроля потока.
3. Запустить OpenOCD командой:

```bash
<path_to_openocd> -c 'set USE_NRST 1' -c 'tcl_port disabled' -c 'telnet_port disabled' -f board/eliot1m_mo.cfg
```

## Работа с программой

- Выполнить команду `bash build.sh` для сборки примера.
- Выполнить команду `arm-none-eabi-gdb-py -x eliot1.gdbinit` для загрузки
  программы на плату.
- Запустить программу на исполнение с помощью gdb команды `continue`.

## Вывод программы после запуска

При успешном запуске будет отображаться на терминале:

```bash
    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    Board CFG: FCLK : 150MHz, SysCLK : 50MHz, VCore 1.10v (DC-DC vlv2), T = X°C
    CORE_0: Started
    The sample is <gender> # определение класса объекта
    Test was executed in N ms # вывод времени выполнения программы
    CORE_1: Started
    The sample is <gender> # определение класса объекта
    Test was executed in N ms # вывод времени выполнения программы
    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
```
