#!/usr/bin/bash

set -o pipefail
set -e

BUILD_DIR="build"
cd `dirname $0`
root_dir=`pwd`
root_repo="$root_dir/../../.."
bsp_dir="$root_repo/boards/eliot1m_mo_cfg/armgcc/bsp_core0"
embeddedcli_dir="$root_repo/middleware/embeddedcli"
toolchain_path="$root_repo/tools/cmake_toolchain_files/armgcc.cmake"

cd $embeddedcli_dir
bash build.sh
cd $root_dir

cd $bsp_dir
bash build.sh
cd $root_dir

if [ ! -d "$BUILD_DIR" ]; then
    mkdir -p "$BUILD_DIR"
fi

echo $root_dir

cd "$BUILD_DIR"
cmake -G "Unix Makefiles" \
    -DCMAKE_TOOLCHAIN_FILE=$toolchain_path \
    $root_dir
make -j$(($(nproc) + 1))
cd $root_dir
