# Обзор

Пример демонстрирует подключение CLI через USB и реализацию простых команд.

## Описание примера

Пример реализации командной консоли Embedded CLI с небольшим набором заложенных команд:

- `cpuinfo` - вывод системной информации о ЦП;
- `help` - вывод списка доступных команд;
- `reboot` - перезагрузка процессора через сброс WDT-счетчика с таймаутом на 0.5 с;
- `settime` - установка времени/даты RWC модуля;
- `timenow` - вывод текущих времени/даты RWC модуля;
- `whoami` - вывод наименования платы.

## Работа с программой

1. В каталоге `middleware/embeddedcli/src/lib/` исполнить скрипт:

    ```
    python build-shl.py
    ```

1. В каталоге `boards/eliot1m_mo/feature_examples/embedded_cli/uart_embedded_cli/cm33_core0/armgcc/` исполнить скрипт:

    ```
    bash build.sh
    ```

1. После сборки примера выполнить команду `arm-none-eabi-gdb-py -x eliot1.gdbinit` для загрузки программы на плату.
1. Запустить программу на исполнение с помощью gdb команды `continue`.
1. Открыть последовательный терминал (пример Putty, Minicom) со следующими
   настройками:
   - скорость 115200 бод;
   - 8 бит данных;
   - нет паритета;
   - один стоповый бит;
   - нет контроля потока.

## Вывод программы после запуска

При успешном запуске будет отображаться на терминале:

```bash
    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    ELIOT01-BUB USB Embedded CLI example
    CLI was started. Enter your commands
    Use command help to see all commands are available
    >
    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
```

Введите на клавиатуре команду help, а затем нажмите кнопку Enter, чтобы увидеть список доступных команд.
