python
import glob
import re

gdb.execute('set pagination off')
gdb.execute('set confirm off')

gdb.execute('target ext localhost:{}'.format(3333))
gdb.execute('mon adapter speed 300')
gdb.execute('mon adapter srst delay 500')
gdb.execute('mon adapter srst pulse_width 1000')
gdb.execute('mon reset halt')

core_programs = [None, None]

for file in glob.glob('*_c*.elf'):
  m = re.search('(?P<core>\d)\.elf', file)
  core_idx = int(m.group('core'))
  core_programs[core_idx] = file

if core_programs[1]:
  print('INFO : launching a dual-core program.')
else:
  print('INFO : launching a single-core program.')

for core_idx in [1, 0]:
  if not (core_programs[core_idx]):
    continue

  gdb.execute('file {}'.format(core_programs[core_idx]))
  gdb.execute('load')
  gdb.execute('compare-sections')
  print('CORE{} LOADED : {}.'.format(core_idx, core_programs[core_idx]))

# gdb.execute('c')
# gdb.execute('p results')
# gdb.execute('q')
end
