/**
 * Copyright (c) 2021-2025, RnD Center «ELVEES», JSC
 * All rights reserved.
 * Contacts: https://elvees.ru, support@elvees.com
 *
 * Project:		SDK
 *
 * SPDX-License-Identifier: BSD-3-Clause
 *
 *
 * Разрешается повторное распространение и использование как в виде исходного кода, так и в объектном коде, 
 * с изменениями или без, при соблюдении следующих условий:
 * 
 * 1. При повторном распространении исходного кода должно оставаться указанное выше уведомление об авторском праве, 
 * этот список условий и последующий отказ от гарантий.
 * 2. При повторном распространении двоичного кода должна сохраняться указанная выше информация об авторском праве, 
 * этот список условий и последующий отказ от гарантий в документации и/или в других материалах, поставляемых при 
 * распространении.
 * 3. Ни название организации, ни имена её сотрудников не могут быть использованы в качестве поддержки или 
 * продвижения продуктов, основанных на этом ПО без предварительного письменного разрешения.
 * ЭТА ПРОГРАММА ПРЕДОСТАВЛЕНА ВЛАДЕЛЬЦАМИ АВТОРСКИХ ПРАВ И/ИЛИ ДРУГИМИ СТОРОНАМИ «КАК ОНА ЕСТЬ» 
 * БЕЗ КАКОГО-ЛИБО ВИДА ГАРАНТИЙ, ВЫРАЖЕННЫХ ЯВНО ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ИМИ, 
 * ПОДРАЗУМЕВАЕМЫЕ ГАРАНТИИ КОММЕРЧЕСКОЙ ЦЕННОСТИ И ПРИГОДНОСТИ ДЛЯ КОНКРЕТНОЙ ЦЕЛИ. НИ В КОЕМ СЛУЧАЕ 
 * НИ ОДИН ВЛАДЕЛЕЦ АВТОРСКИХ ПРАВ И НИ ОДНО ДРУГОЕ ЛИЦО, КОТОРОЕ МОЖЕТ ИЗМЕНЯТЬ И/ИЛИ ПОВТОРНО 
 * РАСПРОСТРАНЯТЬ ПРОГРАММУ, КАК БЫЛО СКАЗАНО ВЫШЕ, НЕ НЕСЁТ ОТВЕТСТВЕННОСТИ, ВКЛЮЧАЯ ЛЮБЫЕ ОБЩИЕ, 
 * СЛУЧАЙНЫЕ, СПЕЦИАЛЬНЫЕ ИЛИ ПОСЛЕДОВАВШИЕ УБЫТКИ, ВСЛЕДСТВИЕ ИСПОЛЬЗОВАНИЯ ИЛИ НЕВОЗМОЖНОСТИ ИСПОЛЬЗОВАНИЯ ПРОГРАММЫ 
 * (ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ПОТЕРЕЙ ДАННЫХ, ИЛИ ДАННЫМИ, СТАВШИМИ НЕПРАВИЛЬНЫМИ, ИЛИ ПОТЕРЯМИ, 
 * ПРИНЕСЕННЫМИ ИЗ-ЗА ВАС ИЛИ ТРЕТЬИХ ЛИЦ, ИЛИ ОТКАЗОМ ПРОГРАММЫ РАБОТАТЬ СОВМЕСТНО С ДРУГИМИ ПРОГРАММАМИ), 
 * ДАЖЕ ЕСЛИ ТАКОЙ ВЛАДЕЛЕЦ ИЛИ ДРУГОЕ ЛИЦО БЫЛИ ИЗВЕЩЕНЫ О ВОЗМОЖНОСТИ ТАКИХ УБЫТКОВ.
 *
 *
 * Redistribution and use in source and binary forms, with or without modification, are permitted provided 
 * that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this list of conditions 
 * and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions 
 * and the following disclaimer in the documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the copyright holder nor the names of its contributors may be used to endorse 
 * or promote products derived from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, 
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED 
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */




/***********************************************************************************************************************
 * This file was generated by the MCUXpresso Config Tools. Any manual edits made to this file
 * will be overwritten if the respective MCUXpresso Config Tools is used to update this file.
 **********************************************************************************************************************/

#ifndef _PIN_MUX_H_
#define _PIN_MUX_H_

/***********************************************************************************************************************
 * Definitions
 **********************************************************************************************************************/

/*! @brief Direction type  */
typedef enum _pin_mux_direction
{
    kPIN_MUX_DirectionInput = 0U,        /* Input direction */
    kPIN_MUX_DirectionOutput = 1U,       /* Output direction */
    kPIN_MUX_DirectionInputOrOutput = 2U /* Input or output direction */
} pin_mux_direction_t;

/*!
 * @addtogroup pin_mux
 * @{
 */

/***********************************************************************************************************************
 * API
 **********************************************************************************************************************/

#if defined(__cplusplus)
extern "C" {
#endif

/*!
 * @brief Calls initialization functions.
 *
 */
void BOARD_InitBootPins(void);

/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void BOARD_InitPins(void);

/*! @name PORTC6 (number 78), U8[11]/SW2
  @{ */
/* Routed pin properties */
#define BOARD_SW2_PERIPHERAL GPIOC                  /*!<@brief Peripheral name */
#define BOARD_SW2_SIGNAL GPIO                       /*!<@brief Signal name */
#define BOARD_SW2_CHANNEL 6                         /*!<@brief Signal channel */
#define BOARD_SW2_PIN_NAME PTC6                     /*!<@brief Routed pin name */
#define BOARD_SW2_LABEL "U8[11]/SW2"                /*!<@brief Label */
#define BOARD_SW2_NAME "SW2"                        /*!<@brief Identifier */
#define BOARD_SW2_DIRECTION kPIN_MUX_DirectionInput /*!<@brief Direction */

/* Symbols to be used with GPIO driver */
#define BOARD_SW2_GPIO GPIOC                        /*!<@brief GPIO peripheral base pointer */
#define BOARD_SW2_GPIO_PIN 6U                       /*!<@brief GPIO pin number */
#define BOARD_SW2_GPIO_PIN_MASK (1U << 6U)          /*!<@brief GPIO pin mask */

/* Symbols to be used with PORT driver */
#define BOARD_SW2_PORT PORTC                        /*!<@brief PORT peripheral base pointer */
#define BOARD_SW2_PIN 6U                            /*!<@brief PORT pin number */
#define BOARD_SW2_PIN_MASK (1U << 6U)               /*!<@brief PORT pin mask */
                                                    /* @} */

/*! @name PORTA4 (number 38), SW3
  @{ */
/* Routed pin properties */
#define BOARD_SW3_PERIPHERAL GPIOA                  /*!<@brief Peripheral name */
#define BOARD_SW3_SIGNAL GPIO                       /*!<@brief Signal name */
#define BOARD_SW3_CHANNEL 4                         /*!<@brief Signal channel */
#define BOARD_SW3_PIN_NAME PTA4                     /*!<@brief Routed pin name */
#define BOARD_SW3_LABEL "SW3"                       /*!<@brief Label */
#define BOARD_SW3_NAME "SW3"                        /*!<@brief Identifier */
#define BOARD_SW3_DIRECTION kPIN_MUX_DirectionInput /*!<@brief Direction */

/* Symbols to be used with GPIO driver */
#define BOARD_SW3_GPIO GPIOA                        /*!<@brief GPIO peripheral base pointer */
#define BOARD_SW3_GPIO_PIN 4U                       /*!<@brief GPIO pin number */
#define BOARD_SW3_GPIO_PIN_MASK (1U << 4U)          /*!<@brief GPIO pin mask */

/* Symbols to be used with PORT driver */
#define BOARD_SW3_PORT PORTA                        /*!<@brief PORT peripheral base pointer */
#define BOARD_SW3_PIN 4U                            /*!<@brief PORT pin number */
#define BOARD_SW3_PIN_MASK (1U << 4U)               /*!<@brief PORT pin mask */
                                                    /* @} */

/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void BOARD_InitButtons(void);

/*! @name PORTB21 (number 67), D12[3]/LEDRGB_BLUE
  @{ */
/* Routed pin properties */
#define BOARD_LED_BLUE_PERIPHERAL GPIOB                   /*!<@brief Peripheral name */
#define BOARD_LED_BLUE_SIGNAL GPIO                        /*!<@brief Signal name */
#define BOARD_LED_BLUE_CHANNEL 21                         /*!<@brief Signal channel */
#define BOARD_LED_BLUE_PIN_NAME PTB21                     /*!<@brief Routed pin name */
#define BOARD_LED_BLUE_LABEL "D12[3]/LEDRGB_BLUE"         /*!<@brief Label */
#define BOARD_LED_BLUE_NAME "LED_BLUE"                    /*!<@brief Identifier */
#define BOARD_LED_BLUE_DIRECTION kPIN_MUX_DirectionOutput /*!<@brief Direction */

/* Symbols to be used with GPIO driver */
#define BOARD_LED_BLUE_GPIO GPIOB                         /*!<@brief GPIO peripheral base pointer */
#define BOARD_LED_BLUE_GPIO_PIN 21U                       /*!<@brief GPIO pin number */
#define BOARD_LED_BLUE_GPIO_PIN_MASK (1U << 21U)          /*!<@brief GPIO pin mask */

/* Symbols to be used with PORT driver */
#define BOARD_LED_BLUE_PORT PORTB                         /*!<@brief PORT peripheral base pointer */
#define BOARD_LED_BLUE_PIN 21U                            /*!<@brief PORT pin number */
#define BOARD_LED_BLUE_PIN_MASK (1U << 21U)               /*!<@brief PORT pin mask */
                                                          /* @} */

/*! @name PORTB22 (number 68), D12[1]/LEDRGB_RED
  @{ */
/* Routed pin properties */
#define BOARD_LED_RED_PERIPHERAL GPIOB                   /*!<@brief Peripheral name */
#define BOARD_LED_RED_SIGNAL GPIO                        /*!<@brief Signal name */
#define BOARD_LED_RED_CHANNEL 22                         /*!<@brief Signal channel */
#define BOARD_LED_RED_PIN_NAME PTB22                     /*!<@brief Routed pin name */
#define BOARD_LED_RED_LABEL "D12[1]/LEDRGB_RED"          /*!<@brief Label */
#define BOARD_LED_RED_NAME "LED_RED"                     /*!<@brief Identifier */
#define BOARD_LED_RED_DIRECTION kPIN_MUX_DirectionOutput /*!<@brief Direction */

/* Symbols to be used with GPIO driver */
#define BOARD_LED_RED_GPIO GPIOB                         /*!<@brief GPIO peripheral base pointer */
#define BOARD_LED_RED_GPIO_PIN 22U                       /*!<@brief GPIO pin number */
#define BOARD_LED_RED_GPIO_PIN_MASK (1U << 22U)          /*!<@brief GPIO pin mask */

/* Symbols to be used with PORT driver */
#define BOARD_LED_RED_PORT PORTB                         /*!<@brief PORT peripheral base pointer */
#define BOARD_LED_RED_PIN 22U                            /*!<@brief PORT pin number */
#define BOARD_LED_RED_PIN_MASK (1U << 22U)               /*!<@brief PORT pin mask */
                                                         /* @} */

/*! @name PORTE26 (number 33), J2[1]/D12[4]/LEDRGB_GREEN
  @{ */
/* Routed pin properties */
#define BOARD_LED_GREEN_PERIPHERAL GPIOE                   /*!<@brief Peripheral name */
#define BOARD_LED_GREEN_SIGNAL GPIO                        /*!<@brief Signal name */
#define BOARD_LED_GREEN_CHANNEL 26                         /*!<@brief Signal channel */
#define BOARD_LED_GREEN_PIN_NAME PTE26                     /*!<@brief Routed pin name */
#define BOARD_LED_GREEN_LABEL "J2[1]/D12[4]/LEDRGB_GREEN"  /*!<@brief Label */
#define BOARD_LED_GREEN_NAME "LED_GREEN"                   /*!<@brief Identifier */
#define BOARD_LED_GREEN_DIRECTION kPIN_MUX_DirectionOutput /*!<@brief Direction */

/* Symbols to be used with GPIO driver */
#define BOARD_LED_GREEN_GPIO GPIOE                         /*!<@brief GPIO peripheral base pointer */
#define BOARD_LED_GREEN_GPIO_PIN 26U                       /*!<@brief GPIO pin number */
#define BOARD_LED_GREEN_GPIO_PIN_MASK (1U << 26U)          /*!<@brief GPIO pin mask */

/* Symbols to be used with PORT driver */
#define BOARD_LED_GREEN_PORT PORTE                         /*!<@brief PORT peripheral base pointer */
#define BOARD_LED_GREEN_PIN 26U                            /*!<@brief PORT pin number */
#define BOARD_LED_GREEN_PIN_MASK (1U << 26U)               /*!<@brief PORT pin mask */
                                                           /* @} */

/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void BOARD_InitLEDs(void);

#define SOPT5_UART0TXSRC_UART_TX 0x00u /*!<@brief UART 0 transmit data source select: UART0_TX pin */

/*! @name PORTB17 (number 63), U10[1]/UART0_TX
  @{ */
/* Routed pin properties */
#define BOARD_DEBUG_UART_TX_PERIPHERAL UART0                   /*!<@brief Peripheral name */
#define BOARD_DEBUG_UART_TX_SIGNAL TX                          /*!<@brief Signal name */
#define BOARD_DEBUG_UART_TX_PIN_NAME UART0_TX                  /*!<@brief Routed pin name */
#define BOARD_DEBUG_UART_TX_LABEL "U10[1]/UART0_TX"            /*!<@brief Label */
#define BOARD_DEBUG_UART_TX_NAME "DEBUG_UART_TX"               /*!<@brief Identifier */
#define BOARD_DEBUG_UART_TX_DIRECTION kPIN_MUX_DirectionOutput /*!<@brief Direction */

/* Symbols to be used with PORT driver */
#define BOARD_DEBUG_UART_TX_PORT PORTB                         /*!<@brief PORT peripheral base pointer */
#define BOARD_DEBUG_UART_TX_PIN 17U                            /*!<@brief PORT pin number */
#define BOARD_DEBUG_UART_TX_PIN_MASK (1U << 17U)               /*!<@brief PORT pin mask */
                                                               /* @} */

/*! @name PORTB16 (number 62), U7[4]/UART0_RX
  @{ */
/* Routed pin properties */
#define BOARD_DEBUG_UART_RX_PERIPHERAL UART0          /*!<@brief Peripheral name */
#define BOARD_DEBUG_UART_RX_SIGNAL RX                 /*!<@brief Signal name */
#define BOARD_DEBUG_UART_RX_PIN_NAME UART0_RX         /*!<@brief Routed pin name */
#define BOARD_DEBUG_UART_RX_LABEL "U7[4]/UART0_RX"    /*!<@brief Label */
#define BOARD_DEBUG_UART_RX_NAME "DEBUG_UART_RX"      /*!<@brief Identifier */

/* Symbols to be used with PORT driver */
#define BOARD_DEBUG_UART_RX_PORT PORTB                /*!<@brief PORT peripheral base pointer */
#define BOARD_DEBUG_UART_RX_PIN 16U                   /*!<@brief PORT pin number */
#define BOARD_DEBUG_UART_RX_PIN_MASK (1U << 16U)      /*!<@brief PORT pin mask */
                                                      /* @} */

/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void BOARD_InitDEBUG_UART(void);

/*! @name PORTA18 (number 50), U13[16]/RMII_RXCLK
  @{ */
/* Routed pin properties */
#define BOARD_EXTAL0_PERIPHERAL OSC             /*!<@brief Peripheral name */
#define BOARD_EXTAL0_SIGNAL EXTAL0              /*!<@brief Signal name */
#define BOARD_EXTAL0_PIN_NAME EXTAL0            /*!<@brief Routed pin name */
#define BOARD_EXTAL0_LABEL "U13[16]/RMII_RXCLK" /*!<@brief Label */
#define BOARD_EXTAL0_NAME "EXTAL0"              /*!<@brief Identifier */

/* Symbols to be used with PORT driver */
#define BOARD_EXTAL0_PORT PORTA                 /*!<@brief PORT peripheral base pointer */
#define BOARD_EXTAL0_PIN 18U                    /*!<@brief PORT pin number */
#define BOARD_EXTAL0_PIN_MASK (1U << 18U)       /*!<@brief PORT pin mask */
                                                /* @} */

/*! @name EXTAL32 (number 29), Y3[2]/EXTAL32_RTC
  @{ */
/* Routed pin properties */
#define BOARD_ETAL32K_PERIPHERAL RTC            /*!<@brief Peripheral name */
#define BOARD_ETAL32K_SIGNAL EXTAL32            /*!<@brief Signal name */
#define BOARD_ETAL32K_PIN_NAME EXTAL32          /*!<@brief Routed pin name */
#define BOARD_ETAL32K_LABEL "Y3[2]/EXTAL32_RTC" /*!<@brief Label */
#define BOARD_ETAL32K_NAME "ETAL32K"            /*!<@brief Identifier */
                                                /* @} */

/*! @name XTAL32 (number 28), Y3[1]/XTAL32_RTC
  @{ */
/* Routed pin properties */
#define BOARD_XTAL32K_PERIPHERAL RTC           /*!<@brief Peripheral name */
#define BOARD_XTAL32K_SIGNAL XTAL32            /*!<@brief Signal name */
#define BOARD_XTAL32K_PIN_NAME XTAL32          /*!<@brief Routed pin name */
#define BOARD_XTAL32K_LABEL "Y3[1]/XTAL32_RTC" /*!<@brief Label */
#define BOARD_XTAL32K_NAME "XTAL32K"           /*!<@brief Identifier */
                                               /* @} */

/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void BOARD_InitOSC(void);

/*! @name PORTE25 (number 32), J2[18]/U8[6]/I2C0_SDA
  @{ */
/* Routed pin properties */
#define BOARD_ACCEL_SDA_PERIPHERAL I2C0               /*!<@brief Peripheral name */
#define BOARD_ACCEL_SDA_SIGNAL SDA                    /*!<@brief Signal name */
#define BOARD_ACCEL_SDA_PIN_NAME I2C0_SDA             /*!<@brief Routed pin name */
#define BOARD_ACCEL_SDA_LABEL "J2[18]/U8[6]/I2C0_SDA" /*!<@brief Label */
#define BOARD_ACCEL_SDA_NAME "ACCEL_SDA"              /*!<@brief Identifier */

/* Symbols to be used with PORT driver */
#define BOARD_ACCEL_SDA_PORT PORTE                    /*!<@brief PORT peripheral base pointer */
#define BOARD_ACCEL_SDA_PIN 25U                       /*!<@brief PORT pin number */
#define BOARD_ACCEL_SDA_PIN_MASK (1U << 25U)          /*!<@brief PORT pin mask */
                                                      /* @} */

/*! @name PORTE24 (number 31), J2[20]/U8[4]/I2C0_SCL
  @{ */
/* Routed pin properties */
#define BOARD_ACCEL_SCL_PERIPHERAL I2C0               /*!<@brief Peripheral name */
#define BOARD_ACCEL_SCL_SIGNAL SCL                    /*!<@brief Signal name */
#define BOARD_ACCEL_SCL_PIN_NAME I2C0_SCL             /*!<@brief Routed pin name */
#define BOARD_ACCEL_SCL_LABEL "J2[20]/U8[4]/I2C0_SCL" /*!<@brief Label */
#define BOARD_ACCEL_SCL_NAME "ACCEL_SCL"              /*!<@brief Identifier */

/* Symbols to be used with PORT driver */
#define BOARD_ACCEL_SCL_PORT PORTE                    /*!<@brief PORT peripheral base pointer */
#define BOARD_ACCEL_SCL_PIN 24U                       /*!<@brief PORT pin number */
#define BOARD_ACCEL_SCL_PIN_MASK (1U << 24U)          /*!<@brief PORT pin mask */
                                                      /* @} */

/*! @name PORTC6 (number 78), U8[11]/SW2
  @{ */
/* Routed pin properties */
#define BOARD_ACCEL_INT1_PERIPHERAL GPIOC                  /*!<@brief Peripheral name */
#define BOARD_ACCEL_INT1_SIGNAL GPIO                       /*!<@brief Signal name */
#define BOARD_ACCEL_INT1_CHANNEL 6                         /*!<@brief Signal channel */
#define BOARD_ACCEL_INT1_PIN_NAME PTC6                     /*!<@brief Routed pin name */
#define BOARD_ACCEL_INT1_LABEL "U8[11]/SW2"                /*!<@brief Label */
#define BOARD_ACCEL_INT1_NAME "ACCEL_INT1"                 /*!<@brief Identifier */
#define BOARD_ACCEL_INT1_DIRECTION kPIN_MUX_DirectionInput /*!<@brief Direction */

/* Symbols to be used with GPIO driver */
#define BOARD_ACCEL_INT1_GPIO GPIOC                        /*!<@brief GPIO peripheral base pointer */
#define BOARD_ACCEL_INT1_GPIO_PIN 6U                       /*!<@brief GPIO pin number */
#define BOARD_ACCEL_INT1_GPIO_PIN_MASK (1U << 6U)          /*!<@brief GPIO pin mask */

/* Symbols to be used with PORT driver */
#define BOARD_ACCEL_INT1_PORT PORTC                        /*!<@brief PORT peripheral base pointer */
#define BOARD_ACCEL_INT1_PIN 6U                            /*!<@brief PORT pin number */
#define BOARD_ACCEL_INT1_PIN_MASK (1U << 6U)               /*!<@brief PORT pin mask */
                                                           /* @} */

/*! @name PORTC13 (number 85), U8[9]
  @{ */
/* Routed pin properties */
#define BOARD_ACCEL_INT2_PERIPHERAL GPIOC                  /*!<@brief Peripheral name */
#define BOARD_ACCEL_INT2_SIGNAL GPIO                       /*!<@brief Signal name */
#define BOARD_ACCEL_INT2_CHANNEL 13                        /*!<@brief Signal channel */
#define BOARD_ACCEL_INT2_PIN_NAME PTC13                    /*!<@brief Routed pin name */
#define BOARD_ACCEL_INT2_LABEL "U8[9]"                     /*!<@brief Label */
#define BOARD_ACCEL_INT2_NAME "ACCEL_INT2"                 /*!<@brief Identifier */
#define BOARD_ACCEL_INT2_DIRECTION kPIN_MUX_DirectionInput /*!<@brief Direction */

/* Symbols to be used with GPIO driver */
#define BOARD_ACCEL_INT2_GPIO GPIOC                        /*!<@brief GPIO peripheral base pointer */
#define BOARD_ACCEL_INT2_GPIO_PIN 13U                      /*!<@brief GPIO pin number */
#define BOARD_ACCEL_INT2_GPIO_PIN_MASK (1U << 13U)         /*!<@brief GPIO pin mask */

/* Symbols to be used with PORT driver */
#define BOARD_ACCEL_INT2_PORT PORTC                        /*!<@brief PORT peripheral base pointer */
#define BOARD_ACCEL_INT2_PIN 13U                           /*!<@brief PORT pin number */
#define BOARD_ACCEL_INT2_PIN_MASK (1U << 13U)              /*!<@brief PORT pin mask */
                                                           /* @} */

/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void BOARD_InitACCEL(void);

#define SOPT2_RMIISRC_EXTAL 0x00u /*!<@brief RMII clock source select: EXTAL clock */

/*! @name PORTB1 (number 54), U13[11]/RMII0_MDC
  @{ */
/* Routed pin properties */
#define BOARD_RMII0_MDC_PERIPHERAL ENET           /*!<@brief Peripheral name */
#define BOARD_RMII0_MDC_SIGNAL RMII_MDC           /*!<@brief Signal name */
#define BOARD_RMII0_MDC_PIN_NAME RMII0_MDC        /*!<@brief Routed pin name */
#define BOARD_RMII0_MDC_LABEL "U13[11]/RMII0_MDC" /*!<@brief Label */
#define BOARD_RMII0_MDC_NAME "RMII0_MDC"          /*!<@brief Identifier */

/* Symbols to be used with PORT driver */
#define BOARD_RMII0_MDC_PORT PORTB                /*!<@brief PORT peripheral base pointer */
#define BOARD_RMII0_MDC_PIN 1U                    /*!<@brief PORT pin number */
#define BOARD_RMII0_MDC_PIN_MASK (1U << 1U)       /*!<@brief PORT pin mask */
                                                  /* @} */

/*! @name PORTB0 (number 53), U13[10]/RMII0_MDIO
  @{ */
/* Routed pin properties */
#define BOARD_RMII0_MDIO_PERIPHERAL ENET            /*!<@brief Peripheral name */
#define BOARD_RMII0_MDIO_SIGNAL RMII_MDIO           /*!<@brief Signal name */
#define BOARD_RMII0_MDIO_PIN_NAME RMII0_MDIO        /*!<@brief Routed pin name */
#define BOARD_RMII0_MDIO_LABEL "U13[10]/RMII0_MDIO" /*!<@brief Label */
#define BOARD_RMII0_MDIO_NAME "RMII0_MDIO"          /*!<@brief Identifier */

/* Symbols to be used with PORT driver */
#define BOARD_RMII0_MDIO_PORT PORTB                 /*!<@brief PORT peripheral base pointer */
#define BOARD_RMII0_MDIO_PIN 0U                     /*!<@brief PORT pin number */
#define BOARD_RMII0_MDIO_PIN_MASK (1U << 0U)        /*!<@brief PORT pin mask */
                                                    /* @} */

/*! @name PORTA13 (number 43), U13[13]/RMII0_RXD_0
  @{ */
/* Routed pin properties */
#define BOARD_RMII0_RXD0_PERIPHERAL ENET             /*!<@brief Peripheral name */
#define BOARD_RMII0_RXD0_SIGNAL RMII_RXD0            /*!<@brief Signal name */
#define BOARD_RMII0_RXD0_PIN_NAME RMII0_RXD0         /*!<@brief Routed pin name */
#define BOARD_RMII0_RXD0_LABEL "U13[13]/RMII0_RXD_0" /*!<@brief Label */
#define BOARD_RMII0_RXD0_NAME "RMII0_RXD0"           /*!<@brief Identifier */

/* Symbols to be used with PORT driver */
#define BOARD_RMII0_RXD0_PORT PORTA                  /*!<@brief PORT peripheral base pointer */
#define BOARD_RMII0_RXD0_PIN 13U                     /*!<@brief PORT pin number */
#define BOARD_RMII0_RXD0_PIN_MASK (1U << 13U)        /*!<@brief PORT pin mask */
                                                     /* @} */

/*! @name PORTA12 (number 42), U13[12]/RMII0_RXD_1
  @{ */
/* Routed pin properties */
#define BOARD_RMII0_RXD1_PERIPHERAL ENET             /*!<@brief Peripheral name */
#define BOARD_RMII0_RXD1_SIGNAL RMII_RXD1            /*!<@brief Signal name */
#define BOARD_RMII0_RXD1_PIN_NAME RMII0_RXD1         /*!<@brief Routed pin name */
#define BOARD_RMII0_RXD1_LABEL "U13[12]/RMII0_RXD_1" /*!<@brief Label */
#define BOARD_RMII0_RXD1_NAME "RMII0_RXD1"           /*!<@brief Identifier */

/* Symbols to be used with PORT driver */
#define BOARD_RMII0_RXD1_PORT PORTA                  /*!<@brief PORT peripheral base pointer */
#define BOARD_RMII0_RXD1_PIN 12U                     /*!<@brief PORT pin number */
#define BOARD_RMII0_RXD1_PIN_MASK (1U << 12U)        /*!<@brief PORT pin mask */
                                                     /* @} */

/*! @name PORTA5 (number 39), U13[17]/RMII0_RXER
  @{ */
/* Routed pin properties */
#define BOARD_RMII0_RXER_PERIPHERAL ENET            /*!<@brief Peripheral name */
#define BOARD_RMII0_RXER_SIGNAL RMII_RXER           /*!<@brief Signal name */
#define BOARD_RMII0_RXER_PIN_NAME RMII0_RXER        /*!<@brief Routed pin name */
#define BOARD_RMII0_RXER_LABEL "U13[17]/RMII0_RXER" /*!<@brief Label */
#define BOARD_RMII0_RXER_NAME "RMII0_RXER"          /*!<@brief Identifier */

/* Symbols to be used with PORT driver */
#define BOARD_RMII0_RXER_PORT PORTA                 /*!<@brief PORT peripheral base pointer */
#define BOARD_RMII0_RXER_PIN 5U                     /*!<@brief PORT pin number */
#define BOARD_RMII0_RXER_PIN_MASK (1U << 5U)        /*!<@brief PORT pin mask */
                                                    /* @} */

/*! @name PORTA16 (number 46), U13[20]/RMII0_TXD0
  @{ */
/* Routed pin properties */
#define BOARD_RMII0_TXD0_PERIPHERAL ENET            /*!<@brief Peripheral name */
#define BOARD_RMII0_TXD0_SIGNAL RMII_TXD0           /*!<@brief Signal name */
#define BOARD_RMII0_TXD0_PIN_NAME RMII0_TXD0        /*!<@brief Routed pin name */
#define BOARD_RMII0_TXD0_LABEL "U13[20]/RMII0_TXD0" /*!<@brief Label */
#define BOARD_RMII0_TXD0_NAME "RMII0_TXD0"          /*!<@brief Identifier */

/* Symbols to be used with PORT driver */
#define BOARD_RMII0_TXD0_PORT PORTA                 /*!<@brief PORT peripheral base pointer */
#define BOARD_RMII0_TXD0_PIN 16U                    /*!<@brief PORT pin number */
#define BOARD_RMII0_TXD0_PIN_MASK (1U << 16U)       /*!<@brief PORT pin mask */
                                                    /* @} */

/*! @name PORTA17 (number 47), U13[21]/RMII0_TXD1
  @{ */
/* Routed pin properties */
#define BOARD_RMII0_TXD1_PERIPHERAL ENET            /*!<@brief Peripheral name */
#define BOARD_RMII0_TXD1_SIGNAL RMII_TXD1           /*!<@brief Signal name */
#define BOARD_RMII0_TXD1_PIN_NAME RMII0_TXD1        /*!<@brief Routed pin name */
#define BOARD_RMII0_TXD1_LABEL "U13[21]/RMII0_TXD1" /*!<@brief Label */
#define BOARD_RMII0_TXD1_NAME "RMII0_TXD1"          /*!<@brief Identifier */

/* Symbols to be used with PORT driver */
#define BOARD_RMII0_TXD1_PORT PORTA                 /*!<@brief PORT peripheral base pointer */
#define BOARD_RMII0_TXD1_PIN 17U                    /*!<@brief PORT pin number */
#define BOARD_RMII0_TXD1_PIN_MASK (1U << 17U)       /*!<@brief PORT pin mask */
                                                    /* @} */

/*! @name PORTA15 (number 45), U13[19]/RMII0_TXEN
  @{ */
/* Routed pin properties */
#define BOARD_RMII0_TXEN_PERIPHERAL ENET            /*!<@brief Peripheral name */
#define BOARD_RMII0_TXEN_SIGNAL RMII_TXEN           /*!<@brief Signal name */
#define BOARD_RMII0_TXEN_PIN_NAME RMII0_TXEN        /*!<@brief Routed pin name */
#define BOARD_RMII0_TXEN_LABEL "U13[19]/RMII0_TXEN" /*!<@brief Label */
#define BOARD_RMII0_TXEN_NAME "RMII0_TXEN"          /*!<@brief Identifier */

/* Symbols to be used with PORT driver */
#define BOARD_RMII0_TXEN_PORT PORTA                 /*!<@brief PORT peripheral base pointer */
#define BOARD_RMII0_TXEN_PIN 15U                    /*!<@brief PORT pin number */
#define BOARD_RMII0_TXEN_PIN_MASK (1U << 15U)       /*!<@brief PORT pin mask */
                                                    /* @} */

/*! @name PORTA14 (number 44), U13[15]/RMII0_CRS_DV
  @{ */
/* Routed pin properties */
#define BOARD_RMII0_CRS_DV_PERIPHERAL ENET              /*!<@brief Peripheral name */
#define BOARD_RMII0_CRS_DV_SIGNAL RMII_CRS_DV           /*!<@brief Signal name */
#define BOARD_RMII0_CRS_DV_PIN_NAME RMII0_CRS_DV        /*!<@brief Routed pin name */
#define BOARD_RMII0_CRS_DV_LABEL "U13[15]/RMII0_CRS_DV" /*!<@brief Label */
#define BOARD_RMII0_CRS_DV_NAME "RMII0_CRS_DV"          /*!<@brief Identifier */

/* Symbols to be used with PORT driver */
#define BOARD_RMII0_CRS_DV_PORT PORTA                   /*!<@brief PORT peripheral base pointer */
#define BOARD_RMII0_CRS_DV_PIN 14U                      /*!<@brief PORT pin number */
#define BOARD_RMII0_CRS_DV_PIN_MASK (1U << 14U)         /*!<@brief PORT pin mask */
                                                        /* @} */

/*! @name PORTA18 (number 50), U13[16]/RMII_RXCLK
  @{ */
/* Routed pin properties */
#define BOARD_RMII_RXCLK_PERIPHERAL ENET            /*!<@brief Peripheral name */
#define BOARD_RMII_RXCLK_SIGNAL RMII_CLKIN          /*!<@brief Signal name */
#define BOARD_RMII_RXCLK_PIN_NAME EXTAL0            /*!<@brief Routed pin name */
#define BOARD_RMII_RXCLK_LABEL "U13[16]/RMII_RXCLK" /*!<@brief Label */
#define BOARD_RMII_RXCLK_NAME "RMII_RXCLK"          /*!<@brief Identifier */

/* Symbols to be used with PORT driver */
#define BOARD_RMII_RXCLK_PORT PORTA                 /*!<@brief PORT peripheral base pointer */
#define BOARD_RMII_RXCLK_PIN 18U                    /*!<@brief PORT pin number */
#define BOARD_RMII_RXCLK_PIN_MASK (1U << 18U)       /*!<@brief PORT pin mask */
                                                    /* @} */

/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void BOARD_InitENET(void);

/*! @name PORTE0 (number 1), J15[P8]/SDHC0_D1
  @{ */
/* Routed pin properties */
#define BOARD_SDHC0_D1_PERIPHERAL SDHC          /*!<@brief Peripheral name */
#define BOARD_SDHC0_D1_SIGNAL DATA              /*!<@brief Signal name */
#define BOARD_SDHC0_D1_CHANNEL 1                /*!<@brief Signal channel */
#define BOARD_SDHC0_D1_PIN_NAME SDHC0_D1        /*!<@brief Routed pin name */
#define BOARD_SDHC0_D1_LABEL "J15[P8]/SDHC0_D1" /*!<@brief Label */
#define BOARD_SDHC0_D1_NAME "SDHC0_D1"          /*!<@brief Identifier */

/* Symbols to be used with PORT driver */
#define BOARD_SDHC0_D1_PORT PORTE               /*!<@brief PORT peripheral base pointer */
#define BOARD_SDHC0_D1_PIN 0U                   /*!<@brief PORT pin number */
#define BOARD_SDHC0_D1_PIN_MASK (1U << 0U)      /*!<@brief PORT pin mask */
                                                /* @} */

/*! @name PORTE1 (number 2), J15[P7]/SDHC0_D0
  @{ */
/* Routed pin properties */
#define BOARD_SDHC0_D0_PERIPHERAL SDHC          /*!<@brief Peripheral name */
#define BOARD_SDHC0_D0_SIGNAL DATA              /*!<@brief Signal name */
#define BOARD_SDHC0_D0_CHANNEL 0                /*!<@brief Signal channel */
#define BOARD_SDHC0_D0_PIN_NAME SDHC0_D0        /*!<@brief Routed pin name */
#define BOARD_SDHC0_D0_LABEL "J15[P7]/SDHC0_D0" /*!<@brief Label */
#define BOARD_SDHC0_D0_NAME "SDHC0_D0"          /*!<@brief Identifier */

/* Symbols to be used with PORT driver */
#define BOARD_SDHC0_D0_PORT PORTE               /*!<@brief PORT peripheral base pointer */
#define BOARD_SDHC0_D0_PIN 1U                   /*!<@brief PORT pin number */
#define BOARD_SDHC0_D0_PIN_MASK (1U << 1U)      /*!<@brief PORT pin mask */
                                                /* @} */

/*! @name PORTE2 (number 3), J15[P5]/SDHC0_DCLK
  @{ */
/* Routed pin properties */
#define BOARD_SDHC0_DCLK_PERIPHERAL SDHC            /*!<@brief Peripheral name */
#define BOARD_SDHC0_DCLK_SIGNAL DCLK                /*!<@brief Signal name */
#define BOARD_SDHC0_DCLK_PIN_NAME SDHC0_DCLK        /*!<@brief Routed pin name */
#define BOARD_SDHC0_DCLK_LABEL "J15[P5]/SDHC0_DCLK" /*!<@brief Label */
#define BOARD_SDHC0_DCLK_NAME "SDHC0_DCLK"          /*!<@brief Identifier */

/* Symbols to be used with PORT driver */
#define BOARD_SDHC0_DCLK_PORT PORTE                 /*!<@brief PORT peripheral base pointer */
#define BOARD_SDHC0_DCLK_PIN 2U                     /*!<@brief PORT pin number */
#define BOARD_SDHC0_DCLK_PIN_MASK (1U << 2U)        /*!<@brief PORT pin mask */
                                                    /* @} */

/*! @name PORTE3 (number 4), J15[P3]/SDHC0_CMD
  @{ */
/* Routed pin properties */
#define BOARD_SDHC0_CMD_PERIPHERAL SDHC           /*!<@brief Peripheral name */
#define BOARD_SDHC0_CMD_SIGNAL CMD                /*!<@brief Signal name */
#define BOARD_SDHC0_CMD_PIN_NAME SDHC0_CMD        /*!<@brief Routed pin name */
#define BOARD_SDHC0_CMD_LABEL "J15[P3]/SDHC0_CMD" /*!<@brief Label */
#define BOARD_SDHC0_CMD_NAME "SDHC0_CMD"          /*!<@brief Identifier */

/* Symbols to be used with PORT driver */
#define BOARD_SDHC0_CMD_PORT PORTE                /*!<@brief PORT peripheral base pointer */
#define BOARD_SDHC0_CMD_PIN 3U                    /*!<@brief PORT pin number */
#define BOARD_SDHC0_CMD_PIN_MASK (1U << 3U)       /*!<@brief PORT pin mask */
                                                  /* @} */

/*! @name PORTE4 (number 5), J15[P2]/SDHC0_D3
  @{ */
/* Routed pin properties */
#define BOARD_SDHC0_D3_PERIPHERAL SDHC          /*!<@brief Peripheral name */
#define BOARD_SDHC0_D3_SIGNAL DATA              /*!<@brief Signal name */
#define BOARD_SDHC0_D3_CHANNEL 3                /*!<@brief Signal channel */
#define BOARD_SDHC0_D3_PIN_NAME SDHC0_D3        /*!<@brief Routed pin name */
#define BOARD_SDHC0_D3_LABEL "J15[P2]/SDHC0_D3" /*!<@brief Label */
#define BOARD_SDHC0_D3_NAME "SDHC0_D3"          /*!<@brief Identifier */

/* Symbols to be used with PORT driver */
#define BOARD_SDHC0_D3_PORT PORTE               /*!<@brief PORT peripheral base pointer */
#define BOARD_SDHC0_D3_PIN 4U                   /*!<@brief PORT pin number */
#define BOARD_SDHC0_D3_PIN_MASK (1U << 4U)      /*!<@brief PORT pin mask */
                                                /* @} */

/*! @name PORTE5 (number 6), J15[P1]/SDHC0_D2
  @{ */
/* Routed pin properties */
#define BOARD_SDHC0_D2_PERIPHERAL SDHC          /*!<@brief Peripheral name */
#define BOARD_SDHC0_D2_SIGNAL DATA              /*!<@brief Signal name */
#define BOARD_SDHC0_D2_CHANNEL 2                /*!<@brief Signal channel */
#define BOARD_SDHC0_D2_PIN_NAME SDHC0_D2        /*!<@brief Routed pin name */
#define BOARD_SDHC0_D2_LABEL "J15[P1]/SDHC0_D2" /*!<@brief Label */
#define BOARD_SDHC0_D2_NAME "SDHC0_D2"          /*!<@brief Identifier */

/* Symbols to be used with PORT driver */
#define BOARD_SDHC0_D2_PORT PORTE               /*!<@brief PORT peripheral base pointer */
#define BOARD_SDHC0_D2_PIN 5U                   /*!<@brief PORT pin number */
#define BOARD_SDHC0_D2_PIN_MASK (1U << 5U)      /*!<@brief PORT pin mask */
                                                /* @} */

/*! @name PORTE6 (number 7), J15[G1]/SD_CARD_DETECT
  @{ */
/* Routed pin properties */
#define BOARD_SDHC_CD_PERIPHERAL GPIOE                  /*!<@brief Peripheral name */
#define BOARD_SDHC_CD_SIGNAL GPIO                       /*!<@brief Signal name */
#define BOARD_SDHC_CD_CHANNEL 6                         /*!<@brief Signal channel */
#define BOARD_SDHC_CD_PIN_NAME PTE6                     /*!<@brief Routed pin name */
#define BOARD_SDHC_CD_LABEL "J15[G1]/SD_CARD_DETECT"    /*!<@brief Label */
#define BOARD_SDHC_CD_NAME "SDHC_CD"                    /*!<@brief Identifier */
#define BOARD_SDHC_CD_DIRECTION kPIN_MUX_DirectionInput /*!<@brief Direction */

/* Symbols to be used with GPIO driver */
#define BOARD_SDHC_CD_GPIO GPIOE                        /*!<@brief GPIO peripheral base pointer */
#define BOARD_SDHC_CD_GPIO_PIN 6U                       /*!<@brief GPIO pin number */
#define BOARD_SDHC_CD_GPIO_PIN_MASK (1U << 6U)          /*!<@brief GPIO pin mask */

/* Symbols to be used with PORT driver */
#define BOARD_SDHC_CD_PORT PORTE                        /*!<@brief PORT peripheral base pointer */
#define BOARD_SDHC_CD_PIN 6U                            /*!<@brief PORT pin number */
#define BOARD_SDHC_CD_PIN_MASK (1U << 6U)               /*!<@brief PORT pin mask */
                                                        /* @} */

/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void BOARD_InitSDHC(void);

/*! @name USB0_DP (number 10), J22[3]/K64_MICRO_USB_DP
  @{ */
/* Routed pin properties */
#define BOARD_USB_DP_PERIPHERAL USB0                 /*!<@brief Peripheral name */
#define BOARD_USB_DP_SIGNAL DP                       /*!<@brief Signal name */
#define BOARD_USB_DP_PIN_NAME USB0_DP                /*!<@brief Routed pin name */
#define BOARD_USB_DP_LABEL "J22[3]/K64_MICRO_USB_DP" /*!<@brief Label */
#define BOARD_USB_DP_NAME "USB_DP"                   /*!<@brief Identifier */
                                                     /* @} */

/*! @name USB0_DM (number 11), J22[2]/K64_MICRO_USB_DN
  @{ */
/* Routed pin properties */
#define BOARD_USB_DM_PERIPHERAL USB0                 /*!<@brief Peripheral name */
#define BOARD_USB_DM_SIGNAL DM                       /*!<@brief Signal name */
#define BOARD_USB_DM_PIN_NAME USB0_DM                /*!<@brief Routed pin name */
#define BOARD_USB_DM_LABEL "J22[2]/K64_MICRO_USB_DN" /*!<@brief Label */
#define BOARD_USB_DM_NAME "USB_DM"                   /*!<@brief Identifier */
                                                     /* @} */

/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void BOARD_InitUSB(void);

#if defined(__cplusplus)
}
#endif

/*!
 * @}
 */
#endif /* _PIN_MUX_H_ */

/***********************************************************************************************************************
 * EOF
 **********************************************************************************************************************/
