/**
 * Copyright (c) 2021-2025, RnD Center «ELVEES», JSC
 * All rights reserved.
 * Contacts: https://elvees.ru, support@elvees.com
 *
 * Project:		SDK
 *
 * SPDX-License-Identifier: BSD-3-Clause
 *
 *
 * Разрешается повторное распространение и использование как в виде исходного кода, так и в объектном коде, 
 * с изменениями или без, при соблюдении следующих условий:
 * 
 * 1. При повторном распространении исходного кода должно оставаться указанное выше уведомление об авторском праве, 
 * этот список условий и последующий отказ от гарантий.
 * 2. При повторном распространении двоичного кода должна сохраняться указанная выше информация об авторском праве, 
 * этот список условий и последующий отказ от гарантий в документации и/или в других материалах, поставляемых при 
 * распространении.
 * 3. Ни название организации, ни имена её сотрудников не могут быть использованы в качестве поддержки или 
 * продвижения продуктов, основанных на этом ПО без предварительного письменного разрешения.
 * ЭТА ПРОГРАММА ПРЕДОСТАВЛЕНА ВЛАДЕЛЬЦАМИ АВТОРСКИХ ПРАВ И/ИЛИ ДРУГИМИ СТОРОНАМИ «КАК ОНА ЕСТЬ» 
 * БЕЗ КАКОГО-ЛИБО ВИДА ГАРАНТИЙ, ВЫРАЖЕННЫХ ЯВНО ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ИМИ, 
 * ПОДРАЗУМЕВАЕМЫЕ ГАРАНТИИ КОММЕРЧЕСКОЙ ЦЕННОСТИ И ПРИГОДНОСТИ ДЛЯ КОНКРЕТНОЙ ЦЕЛИ. НИ В КОЕМ СЛУЧАЕ 
 * НИ ОДИН ВЛАДЕЛЕЦ АВТОРСКИХ ПРАВ И НИ ОДНО ДРУГОЕ ЛИЦО, КОТОРОЕ МОЖЕТ ИЗМЕНЯТЬ И/ИЛИ ПОВТОРНО 
 * РАСПРОСТРАНЯТЬ ПРОГРАММУ, КАК БЫЛО СКАЗАНО ВЫШЕ, НЕ НЕСЁТ ОТВЕТСТВЕННОСТИ, ВКЛЮЧАЯ ЛЮБЫЕ ОБЩИЕ, 
 * СЛУЧАЙНЫЕ, СПЕЦИАЛЬНЫЕ ИЛИ ПОСЛЕДОВАВШИЕ УБЫТКИ, ВСЛЕДСТВИЕ ИСПОЛЬЗОВАНИЯ ИЛИ НЕВОЗМОЖНОСТИ ИСПОЛЬЗОВАНИЯ ПРОГРАММЫ 
 * (ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ПОТЕРЕЙ ДАННЫХ, ИЛИ ДАННЫМИ, СТАВШИМИ НЕПРАВИЛЬНЫМИ, ИЛИ ПОТЕРЯМИ, 
 * ПРИНЕСЕННЫМИ ИЗ-ЗА ВАС ИЛИ ТРЕТЬИХ ЛИЦ, ИЛИ ОТКАЗОМ ПРОГРАММЫ РАБОТАТЬ СОВМЕСТНО С ДРУГИМИ ПРОГРАММАМИ), 
 * ДАЖЕ ЕСЛИ ТАКОЙ ВЛАДЕЛЕЦ ИЛИ ДРУГОЕ ЛИЦО БЫЛИ ИЗВЕЩЕНЫ О ВОЗМОЖНОСТИ ТАКИХ УБЫТКОВ.
 *
 *
 * Redistribution and use in source and binary forms, with or without modification, are permitted provided 
 * that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this list of conditions 
 * and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions 
 * and the following disclaimer in the documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the copyright holder nor the names of its contributors may be used to endorse 
 * or promote products derived from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, 
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED 
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */




/*!
 * @brief Описание стандартов QSPI NOR Flash
 *
 * Описание версий и регистров карты стандартов.
 * Подробности в документации на JESD216.
 */

/*!
 * @file hal_qspi_nor_jesd.h
 */

#ifndef HAL_QSPI_NOR_JESD_H
#define HAL_QSPI_NOR_JESD_H

#ifdef  __cplusplus
extern "C" {
#endif

enum {
    Sfdp_Version_Major_1_0 = 1,
    Sfdp_Version_Minor_0   = 0, /* Стандарт JESD216 */
    Sfdp_Version_Minor_A   = 5, /* Стандарт JESD216A */
    Sfdp_Version_Minor_B   = 6, /* Стандарт JESD216B */
    Sfdp_Version_Minor_C   = 7, /* Стандарт JESD216C */

    Sfdp_BasicProtocolTableSize_Rev0 = 36,
    Sfdp_BasicProtocolTableSize_RevA = 64,
    Sfdp_BasicProtocolTableSize_RevB = Sfdp_BasicProtocolTableSize_RevA,
    Sfdp_BasicProtocolTableSize_RevC = 80,
};

enum {
    ParameterID_BasicSpiProtocol             = 0xFF00,
    /* Новая таблица добавлена в JESD216B */
    ParameterID_SectorMap                    = 0xFF81,
    ParameterID_4ByteAddressInstructionTable = 0xFF84,
    /* Новая таблица добавлена в JESD216C */
    ParameterID_xSpiProfile1_0               = 0xFF85,
    ParameterID_xSpiOrofile2_0               = 0xFF86,
    ParameterID_StaCtrlCfgRegMap             = 0xFF87,
    ParameterID_OpiEnableSeq                 = 0xFF09,
};

/*!@brief Typical time sector erase units */
enum {
    ParameterID_SectorErase_1ms   = 0x00,
    ParameterID_SectorErase_16ms  = 0x01,
    ParameterID_SectorErase_128ms = 0x02,
    ParameterID_SectorErase_1s    = 0x03,
};

/*!@brief Typical time chip erase units */
enum {
    ParameterID_ChipErase_16ms  = 0x00,
    ParameterID_ChipErase_256ms = 0x01,
    ParameterID_ChipErase_4s    = 0x02,
    ParameterID_ChipErase_64s   = 0x03,
};

/*!@brief Typical time page program units */
enum {
    ParameterID_PageProg_8us  = 0x00,
    ParameterID_PageProg_64us = 0x01,
};

/*!@brief Quad Enable Requirements (QER) field */
enum {
    ParameterID_QER_None           = 0x000,
    ParameterID_QER_Bit1_SR2       = 0x001,
    ParameterID_QER_Bit6_SR1       = 0x002,
    ParameterID_QER_Bit7_SR2       = 0x003,
    ParameterID_QER_Bit1_SR2_NoMod = 0x004,
    ParameterID_QER_Bit1_SR2_0x01  = 0x005,
    ParameterID_QER_Bit1_SR2_0x31  = 0x006,
};

typedef struct _sfdp_header {
    uint32_t signature;
    uint8_t  minor_rev;
    uint8_t  major_rev;
    uint8_t  param_hdr_num;
    uint8_t  sfdp_access_protocol; /* Описано в JESD216C, зарезервировано
                                    * для старых версий */
} sfdp_header_t;

/*!@brief SFDP Parameter Header */
typedef struct _sfdp_parameter_header {
    uint8_t parameter_id_lsb;
    uint8_t minor_rev;
    uint8_t major_rev;
    uint8_t table_length_in_32bit;
    uint8_t parameter_table_pointer[3];
    uint8_t parameter_id_msb;
} sfdp_parameter_header_t;

/*!@brief Basic Flash Parameter Table, see JESD216B doc for more details */
typedef struct _jedec_flash_param_table {
    struct {
        uint32_t erase_size               : 2;
        uint32_t write_granularity        : 1;
        uint32_t reserved0                : 2;
        uint32_t unused0                  : 3;
        uint32_t erase4k_inst             : 8;
        uint32_t support_1_1_2_fast_read  : 1;
        uint32_t address_bytes            : 2;
        uint32_t support_ddr_clocking     : 1;
        uint32_t support_1_2_2_fast_read  : 1;
        uint32_t supports_1_4_4_fast_read : 1;
        uint32_t support_1_1_4_fast_read  : 1;
        uint32_t unused1                  : 9;
    } misc;
    uint32_t flash_density;
    struct {
        uint32_t dummy_clocks_1_4_4_read : 5;
        uint32_t mode_clocks_1_4_4_read  : 3;
        uint32_t inst_1_4_4_read         : 8;
        uint32_t dummy_clocks_1_1_4_read : 5;
        uint32_t mode_clocks_1_1_4_read  : 3;
        uint32_t inst_1_1_4_read         : 8;
    } read_1_4_info;
    struct {
        uint32_t dummy_clocks_1_2_2_read : 5;
        uint32_t mode_clocks_1_2_2_read  : 3;
        uint32_t inst_1_2_2_read         : 8;
        uint32_t dummy_clocks_1_1_2_read : 5;
        uint32_t mode_clocks_1_1_2_read  : 3;
        uint32_t inst_1_1_2_read         : 8;
    } read_1_2_info;
    struct {
        uint32_t support_2_2_2_fast_read : 1;
        uint32_t reserved0               : 3;
        uint32_t support_4_4_4_fast_read : 1;
        uint32_t reserved1               : 27;
    } read_22_44_check;
    struct {
        uint32_t reserved0               : 16;
        uint32_t dummy_clocks_2_2_2_read : 5;
        uint32_t mode_clocks_2_2_2_read  : 3;
        uint32_t inst_2_2_2_read         : 8;
    } read_2_2_info;
    struct {
        uint32_t reserved0               : 16;
        uint32_t dummy_clocks_4_4_4_read : 5;
        uint32_t mode_clocks_4_4_4_read  : 3;
        uint32_t inst_4_4_4_read         : 8;
    } read_4_4_info;
    struct {
        uint8_t size;
        uint8_t inst;
    } erase_info[4];
    struct {
        uint32_t mult_typ_to_max_erase : 4;
        uint32_t sector_type_1_typ     : 7;
        uint32_t sector_type_2_typ     : 7;
        uint32_t sector_type_3_typ     : 7;
        uint32_t sector_type_4_typ     : 7;
    } sector_erase_timing;
    struct {
        uint32_t mult_typ_to_max_prog : 4;
        uint32_t page_size            : 4;
        uint32_t page_prog_typ        : 6;
        uint32_t byte_prog_typ        : 5;
        uint32_t byte_prog_typ_add    : 5;
        uint32_t chip_erase_typ       : 7;
        uint32_t reserved             : 1;
    } chip_erase_progrm_info;
    struct {
        uint32_t suspend_resume_spec;
        uint32_t suspend_resume_inst;
    } suspend_resume_info;
    struct {
        uint32_t reserved0           : 2;
        uint32_t busy_status_polling : 6;
        uint32_t reserved1           : 24;
    } busy_status_info;
    struct {
        uint32_t mode_4_4_4_disable_seq  : 4;
        uint32_t mode_4_4_4_enable_seq   : 5;
        uint32_t support_mode_0_4_4      : 1;
        uint32_t mode_0_4_4_exit_method  : 6;
        uint32_t mode_0_4_4_entry_method : 4;
        uint32_t quad_enable_requirement : 3;
        uint32_t hold_reset_disable      : 1;
        uint32_t reserved0               : 8;
    } mode_4_4_info;
    struct {
        uint32_t status_reg_write_enable   : 7;
        uint32_t reserved0                 : 1;
        uint32_t soft_reset_rescue_support : 6;
        uint32_t exit_4_byte_addressing    : 10;
        uint32_t enter_4_byte_addrssing    : 8;
    } mode_config_info;
} jedec_flash_param_table_t;

/*!@brief 4Byte Addressing Instruction Table */
typedef struct _jedec_4byte_addressing_inst_table {
    struct {
        uint32_t support_1_1_1_read                        : 1;
        uint32_t support_1_1_1_fast_read                   : 1;
        uint32_t support_1_1_2_fast_read                   : 1;
        uint32_t support_1_2_2_fast_read                   : 1;
        uint32_t support_1_1_4_fast_read                   : 1;
        uint32_t support_1_4_4_fast_read                   : 1;
        uint32_t support_1_1_1_page_program                : 1;
        uint32_t support_1_1_4_page_program                : 1;
        uint32_t support_1_4_4_page_program                : 1;
        uint32_t support_erase_type1_size                  : 1;
        uint32_t support_erase_type2_size                  : 1;
        uint32_t support_erase_type3_size                  : 1;
        uint32_t support_erase_type4_size                  : 1;
        uint32_t support_1_1_1_dtr_read                    : 1;
        uint32_t support_1_2_2_dtr_read                    : 1;
        uint32_t support_1_4_4_dtr_read                    : 1;
        uint32_t support_volatile_sector_lock_read_cmd     : 1;
        uint32_t support_volatile_sector_lock_write_cmd    : 1;
        uint32_t support_nonvolatile_sector_lock_read_cmd  : 1;
        uint32_t support_nonvolatile_sector_lock_write_cmd : 1;
        uint32_t reserved                                  : 12;
    } cmd_4byte_support_info;
    struct {
        uint8_t erase_inst[4];
    } erase_inst_info;
} jedec_4byte_addressing_inst_table_t;

typedef struct _jdec_query_table {
    uint32_t standard_version; /* JESD216 */
    uint32_t flash_param_tbl_size;
    jedec_flash_param_table_t flash_param_tbl;
    bool has_4b_addressing_inst_table;
    jedec_4byte_addressing_inst_table_t flash_4b_inst_tbl;
} jedec_info_table_t;

#ifdef  __cplusplus
}
#endif

#endif  /* HAL_QSPI_NOR_JESD_H */
