GROUP(libgcc.a libc.a libm.a)

/* Non-secure address map */
__CORE0_ROM_BASE = 0x00000000;
__CORE0_ROM_SIZE = 0x00080000;
__CORE0_RAM_BASE = 0x20000000;
__CORE0_RAM_SIZE = 0x00040000;
__CORE1_ROM_BASE = 0x00080000;
__CORE1_ROM_SIZE = 0x00020000;
__CORE1_RAM_BASE = 0x20040000;
__CORE1_RAM_SIZE = 0x00010000;

__STACK_SIZE     = 0x00000800;
__SHMEM_SIZE     = 0x00001000;

/* Entry Point */
ENTRY(Reset_Handler)


MEMORY
{
  FLASH   (rxa) : ORIGIN = __CORE1_ROM_BASE, LENGTH = __CORE1_ROM_SIZE
  RAM     (rwx) : ORIGIN = __CORE1_RAM_BASE, LENGTH = __CORE1_RAM_SIZE
  SH_RAM  (rw)  : ORIGIN = __CORE0_RAM_BASE + __CORE0_RAM_SIZE - __SHMEM_SIZE, LENGTH = __SHMEM_SIZE
}

REGION_ALIAS("REGION_TEXT",       RAM);
REGION_ALIAS("REGION_EXTAB",      RAM);
REGION_ALIAS("REGION_EXIDX",      RAM);
REGION_ALIAS("REGION_COPY_TABLE", RAM);
REGION_ALIAS("REGION_ZERO_TABLE", RAM);

REGION_ALIAS("REGION_DATA",  RAM);
REGION_ALIAS("REGION_BSS",   RAM);
REGION_ALIAS("REGION_HEAP",  RAM);
REGION_ALIAS("REGION_STACK", RAM);
REGION_ALIAS("REGION_SHMEM", SH_RAM);

__Vectors_CPU0 = __CORE0_RAM_BASE;
__Vectors_CPU1 = __CORE1_RAM_BASE;

SECTIONS
{
    /* NOINIT section for rpmsg_sh_mem */
  .noinit_rpmsg_sh_mem (NOLOAD) : ALIGN(4)
  {
     __RPMSG_SH_MEM_START__ = .;
     *(.noinit.$rpmsg_sh_mem*)
     *(*rpmsg_sh_mem_section*)
     . = ALIGN(4) ;
     __RPMSG_SH_MEM_END__ = .;
  } > REGION_SHMEM AT > REGION_SHMEM

  .vectors :
  {
    KEEP(*(.vectors .vectors*))
  }> REGION_TEXT AT > REGION_TEXT

  .text :
  {
    *(.text .text*)
    KEEP(*(.init .init.*))
    KEEP(*(.fini .fini.*))

    /* .ctors */
    *crtbegin.o(.ctors)
    *crtbegin?.o(.ctors)
    *(EXCLUDE_FILE(*crtend?.o *crtend.o) .ctors)
    *(SORT(.ctors.*))
    *(.ctors)

    /* .dtors */
    *crtbegin.o(.dtors)
    *crtbegin?.o(.dtors)
    *(EXCLUDE_FILE(*crtend?.o *crtend.o) .dtors)
    *(SORT(.dtors.*))
    *(.dtors)

    *(.rodata .rodata.*)
    *(.glue_7 .glue_7.*)
    *(.glue_7t .glue_7t.*)
    KEEP(*(.eh_frame*))
    . = ALIGN(4);
  } > REGION_TEXT AT > REGION_TEXT

  .ARM.extab :
  {
    *(.ARM.extab* .gnu.linkonce.armextab.*)
  } > REGION_EXTAB AT > REGION_EXTAB

  .ARM.exidx :
  {
    __exidx_start = .;
    *(.ARM.exidx*  .gnu.linkonce.armexidx.*)
    __exidx_end = .;
  } > REGION_EXIDX AT > REGION_EXIDX

  PROVIDE(__copy_table_start__ = 0);
  PROVIDE(__copy_table_end__ = 0);

  .zero.table :
  {
    . = ALIGN(4);
    __zero_table_start__ = .;
    /* Add each additional bss section here */
/*
    LONG (__bss2_start__)
    LONG ((__bss2_end__ - __bss2_start__) / 4)
*/
    __zero_table_end__ = .;
    __etext = ALIGN (4);
  } > REGION_ZERO_TABLE AT > REGION_ZERO_TABLE

  /**
   * Location counter can end up 2byte aligned with narrow Thumb code but
   * __etext is assumed by startup code to be the LMA of a section in RAM
   * which must be 4byte aligned
   */

  .data : ALIGN(4)
  {
    __data_start__ = .;

    *(vtable)
    *(.data)
    *(.data.*)
    *(.ramfunc*)             /* for functions in ram */

    . = ALIGN(4);
    /* preinit data */
    PROVIDE_HIDDEN (__preinit_array_start = .);
    KEEP(*(.preinit_array))
    PROVIDE_HIDDEN (__preinit_array_end = .);

    . = ALIGN(4);
    /* init data */
    PROVIDE_HIDDEN (__init_array_start = .);
    KEEP(*(SORT(.init_array.*)))
    KEEP(*(.init_array))
    PROVIDE_HIDDEN (__init_array_end = .);

    . = ALIGN(4);
    /* finit data */
    PROVIDE_HIDDEN (__fini_array_start = .);
    KEEP(*(SORT(.fini_array.*)))
    KEEP(*(.fini_array))
    PROVIDE_HIDDEN (__fini_array_end = .);

    KEEP(*(.jcr*))
    . = ALIGN(4);
    /* All data end */
    __data_end__ = .;

  } > REGION_DATA

  .bss :
  {
    . = ALIGN(4);
    __bss_start__ = .;
    *(.bss)
    *(.bss.*)
    *(COMMON)
    . = ALIGN(4);
    __bss_end__ = .;
  } > REGION_BSS AT > REGION_BSS

  .heap (COPY) :
  {
    . = ALIGN(8);
    __end__ = .;
    PROVIDE(end = .);
    __HeapBase = .;
    . += ORIGIN(RAM) + LENGTH(RAM) - __end__ - __STACK_SIZE - 16;
    __HeapLimit = .;
    __heap_limit = .;
  } > REGION_HEAP AT > REGION_HEAP

  .stack (COPY) :
  {
    __StackTop = ORIGIN(RAM) + LENGTH(RAM) - 16;
    __StackLimit = __StackTop - __STACK_SIZE + 16;
    PROVIDE(__stack = __StackTop);
  } > REGION_STACK AT > REGION_STACK

  ASSERT((ORIGIN(RAM) + LENGTH(RAM) - __end__) < __StackLimit, "REGION_DATA overflowed with stack and heap")
}
