ENTRY(Reset_Handler)

MEMORY
{
    ROM (rx)  : ORIGIN = 0x1E000000, LENGTH = 1K
    RAM (rwx) : ORIGIN = 0x30020000, LENGTH = 8K
}

SECTIONS
{
    .text :
    {
        KEEP(*(.vectors))

        _ftext = .;
        * (.text .text.*);
        * (.init .init.*)
        * (.fini .fini.*)
        * (.reginfo .reginfo.*)
        . = ALIGN(4);
    } > ROM

    .ARM.extab :
    {
        * (.ARM.extab* .gnu.linkonce.armextab.*)
    } > ROM

    __exidx_start = .;
    .ARM.exidx :
    {
        * (.ARM.exidx* .gnu.linkonce.armexidx.*)
    } > ROM
    __exidx_end = .;

    __StackTop = ORIGIN(RAM) + LENGTH(RAM);
    __StackLimit = ORIGIN(RAM);
    PROVIDE(end = .);
    PROVIDE(__stack = __StackTop);
}
