# Первичный загрузчик System Flash

Простой загрузчик программы cpu0 ядра из flash памяти.

## Описание работы

Программа загрузчика расположена в системном разделе flash памяти по адресу
0x10200000. После сброса cpu0 по умолчанию стартует с этого адреса. Загрузчик
считывает по адресу основного раздела flash 0x10000000 два значения:

```bash
0x10000000 - указатель на стек
0x10000004 - стартовый адрес программы
```

Далее идёт проверка стартового адреса загружаемой программы по всем возможным
допустимым областям памяти для исполнения. Если адрес не попал ни в одну
область, то возможно flash память не содержит валидный загружаемый образ
программы (например, если программа будет исполняться из RAM памяти через
отладчик), загрузчик переходит в бесконечный цикл ожидания.

## Скрипты загрузки и сборки

- load.sh - прошивка первичного загрузчика в системную флеш через GDB
- build.sh - сборка первичного загрузчика, результат сборки помещает в папку
  /bin

Перед загрузкой основной программы необходимо один раз загрузить первичный
загрузчик во flash память путем запуска скрипта:

```bash
bash load.sh
```

Первичный загрузчик уже собран и лежит в папке /bin.

Если требуется пересборка загрузчика (доработка, отладка), то необходимо
запустить скрипт сборки:

```bash
bash build.sh
```

## Настройка необходимого окружения

1. Прописать в переменную PATH путь до папки /bin инструментов сборки
   ARM GCC 10.3.1 версии и выше, чтобы инструменты вызывались из командной
   строки без использования полного пути:
   ```bash
   arm-none-eabi-gdb-py
   arm-none-eabi-gcc
   ```
1. Запустить Openocd в соотвествующей конфигурации для вашей платы, чтобы у
   отладчика GDB был необходимый доступ.
1. Загружаемая программа должна собираться только в начало основного раздела
   flash по адресам
   ```bash
   0x00000000 - Non-secure flash адрес
   0x10000000 - Secure flash адрес
   ```
   Первое слово загружаемой программы должно содержать значение указателя стека,
   второе - адрес входа в программу.
