#!/usr/bin/env bash

gdb_path="arm-none-eabi-gdb-py"
gdb_init="eliot1_flashload.gdbinit"

which $gdb_path 0>/dev/null 2>/dev/null

if [[ $? != 0 && ! -f $gdb_path ]]
then
    echo "ERROR: GDB is not found"
    exit -1
fi

if [ ! -f $gdb_init ]
then
    echo "ERROR: GDB InitFile is not found"
    exit -2
fi

set -e

$gdb_path -x $gdb_init

echo "Completed"
