
                .syntax  unified
                .arch    armv8-m.main

                .section .vectors, "a"
                .align   2
                .globl   __Vectors
                .globl   __Vectors_End
                .globl   __Vectors_Size
__Vectors:
                .long    __StackTop                         /* Top of Stack */

                .long    Reset_Handler                      /* 0   -15  Reset Handler */
                .long    NMI_Handler                        /* 2   -14  NMI Handler */
                .long    HardFault_Handler                  /* 3   -13  Hard Fault Handler */
                .long    MemManage_Handler                  /* 4   -12  MPU Fault Handler */
                .long    BusFault_Handler                   /* 5   -11  Bus Fault Handler */
                .long    UsageFault_Handler                 /* 6   -10  Usage Fault Handler */
                .long    SecureFault_Handler                /* 7   -9   Secure Fault Handler */
                .long    0                                  /* 8        Reserved */
                .long    0                                  /* 9        Reserved */
                .long    0                                  /* 10       Reserved */
                .long    SVC_Handler                        /* 11  -5   SVCall Handler */
                .long    DebugMon_Handler                   /* 12  -4   Debug Monitor Handler */
                .long    0                                  /* 13       Reserved */
                .long    PendSV_Handler                     /* 14  -2   PendSV Handler */
                .long    SysTick_Handler                    /* 15  -1   SysTick Handler */

                /* Interrupts */
                .long    NSWDT_RST_Handler                  /* 16  0    NSWDT_RST */
                .long    NSWDT_Handler                      /* 17  1    NSWDT */
                .long    LPTIM_Handler                      /* 18  2    LPTIM */
                .long    TIM0_Handler                       /* 19  3    TIM0 */
                .long    TIM1_Handler                       /* 20  4    TIM1 */
                .long    DTIM_Handler                       /* 21  5    DTIM */
                .long    MHU0_Handler                       /* 22  6    MHU0 */
                .long    MHU1_Handler                       /* 23  7    MHU1 */
                .long    CRYPTO_Handler                     /* 24  8    CRYPTO */
                .long    MPC_Handler                        /* 25  9    MPC */
                .long    PPC_Handler                        /* 26  10   PPC */
                .long    MSC_Handler                        /* 27  11   MSC */
                .long    BRG_Handler                        /* 28  12   BRG */
                .long    ICACHE_Handler                     /* 29  13   ICACHE */
                .long    0                                  /* 30  14   Reserved */
                .long    SYS_PPU_Handler                    /* 31  15   SYS_PPU */
                .long    CPU0_PPU_Handler                   /* 32  16   CPU0_PPU */
                .long    CPU1_PPU_Handler                   /* 33  17   CPU1_PPU */
                .long    0                                  /* 34  18   Reserved */
                .long    0                                  /* 35  19   Reserved */
                .long    CRYPTO_PPU_Handler                 /* 36  20   CRYPTO_PPU */
                .long    0                                  /* 37  21   Reserved */
                .long    RAM0_PPU_Handler                   /* 38  22   RAM0_PPU */
                .long    RAM1_PPU_Handler                   /* 39  23   RAM1_PPU */
                .long    RAM2_PPU_Handler                   /* 40  24   RAM2_PPU */
                .long    RAM3_PPU_Handler                   /* 41  25   RAM3_PPU */
                .long    DEBUG_PPU_Handler                  /* 42  26   DEBUG_PPU */
                .long    0                                  /* 43  27   Reserved */
                .long    CPUCTIIRQ0_Handler                 /* 44  28   CPUnCTIIRQ0 */
                .long    CPUCTIIRQ1_Handler                 /* 45  29   CPUnCTIIRQ1 */
                .long    0                                  /* 46  30   Reserved */
                .long    0                                  /* 47  31   Reserved */
                .long    UART0_Handler                      /* 48  32   UART0 */
                .long    UART1_Handler                      /* 49  33   UART1 */
                .long    UART2_Handler                      /* 50  34   UART2 */
                .long    UART3_Handler                      /* 51  35   UART3 */
                .long    SPI0_Handler                       /* 52  36   SPI0 */
                .long    SPI1_Handler                       /* 53  37   SPI1 */
                .long    SPI2_Handler                       /* 54  38   SPI2 */
                .long    I2C0_Handler                       /* 55  39   I2C0 */
                .long    I2C1_Handler                       /* 56  40   I2C1 */
                .long    I2S_Handler                        /* 57  41   I2S */
                .long    GPIO0_S_Handler                    /* 58  42   GPIO0_S */
                .long    GPIO1_S_Handler                    /* 59  43   GPIO1_S */
                .long    GPIO2_S_Handler                    /* 60  44   GPIO2_S */
                .long    GPIO3_S_Handler                    /* 61  45   GPIO3_S */
                .long    CAN_Handler                        /* 62  46   CAN */
                .long    PWM_Handler                        /* 63  47   PWM */
                .long    VTU0_Handler                       /* 64  48   VTU0 */
                .long    VTU1_Handler                       /* 65  49   VTU1 */
                .long    FCACHE_Handler                     /* 66  50   FCACHE */
                .long    FCTR_Handler                       /* 67  51   FCTR */
                .long    QSPI_Handler                       /* 68  52   QSPI */
                .long    0                                  /* 69  53   Reserved */
                .long    GNSS_Handler                       /* 70  54   GNSS */
                .long    DMA0_Handler                       /* 71  55   DMA0 */
                .long    DMA1_Handler                       /* 72  56   DMA1 */
                .long    SDMMC_Handler                      /* 73  57   SDMMC */
                .long    USB_Handler                        /* 74  58   USB */
                .long    JTM_Handler                        /* 75  59   JTM */
                .long    GMS_URB_Handler                    /* 76  60   GMS_URB */
                .long    GMS_DMA_Handler                    /* 77  61   GMS_DMA */
                .long    GMS_PPU_Handler                    /* 78  62   GMS_PPU */
                .long    GNSS_PPU_Handler                   /* 79  63   GNSS_PPU */
                .long    RWC_WKUP_Handler                   /* 80  64   RWC_WKUP */
                .long    RWC_TICK_Handler                   /* 81  65   RWC_TICK */
                .long    RWC_ALARM_Handler                  /* 82  66   RWC_ALARM */
                .long    DMA0_CH0_Handler                   /* 83  67   DMA0_CH0 */
                .long    DMA0_CH1_Handler                   /* 84  68   DMA0_CH1 */
                .long    DMA0_CH2_Handler                   /* 85  69   DMA0_CH2 */
                .long    DMA0_CH3_Handler                   /* 86  70   DMA0_CH3 */
                .long    DMA0_CH4_Handler                   /* 87  71   DMA0_CH4 */
                .long    DMA0_CH5_Handler                   /* 88  72   DMA0_CH5 */
                .long    DMA0_CH6_Handler                   /* 89  73   DMA0_CH6 */
                .long    DMA0_CH7_Handler                   /* 90  74   DMA0_CH7 */
                .long    DMA1_CH0_Handler                   /* 91  75   DMA1_CH0 */
                .long    DMA1_CH1_Handler                   /* 92  76   DMA1_CH1 */
                .long    DMA1_CH2_Handler                   /* 93  77   DMA1_CH2 */
                .long    DMA1_CH3_Handler                   /* 94  78   DMA1_CH3 */
                .long    DMA1_CH4_Handler                   /* 95  79   DMA1_CH4 */
                .long    DMA1_CH5_Handler                   /* 96  80   DMA1_CH5 */
                .long    DMA1_CH6_Handler                   /* 97  81   DMA1_CH6 */
                .long    DMA1_CH7_Handler                   /* 98  82   DMA1_CH7 */
                .long    VMON_Handler                       /* 99  83   VMON */
                .long    SDMMC_WKUP_Handler                 /* 100 84   SDMMC_WKUP */
                .long    GPIO0_NS_Handler                   /* 101 85   GPIO0_NS */
                .long    GPIO1_NS_Handler                   /* 102 86   GPIO1_NS */
                .long    GPIO2_NS_Handler                   /* 103 87   GPIO2_NS */
                .long    GPIO3_NS_Handler                   /* 104 88   GPIO3_NS */
                .long    GPIO0_ACC_Handler                  /* 105 89   GPIO0_ACC */
                .long    GPIO1_ACC_Handler                  /* 106 90   GPIO1_ACC */
                .long    GPIO2_ACC_Handler                  /* 107 91   GPIO2_ACC */
                .long    GPIO3_ACC_Handler                  /* 108 92   GPIO3_ACC */

                /* Interrupts 93 .. 480 are left out */
__Vectors_End:
                .equ     __Vectors_Size, __Vectors_End - __Vectors
                .size    __Vectors, . - __Vectors


                .thumb
                .section .text, "ax"
                .align   2

                .thumb_func
                .type    Reset_Handler, %function
                .globl   Reset_Handler
                .fnstart
Reset_Handler:

                nop
                ldr      sp, =__StackTop    /* set stack pointer */
                ldr      r0, =BOOT_ADDR
                ldr      r0, [r0, #4]
                bl       check_boot_address
                ldr      r1, =BOOT_ADDR
                ldr      sp, [r1]
                blx      r0
                b        .
                .fnend
                .size    Reset_Handler, . - Reset_Handler

/* The default macro is not used for HardFault_Handler
 * because this results in a poor debug illusion.
 */
                .thumb_func
                .type    HardFault_Handler, %function
                .weak    HardFault_Handler
                .fnstart
HardFault_Handler:
                b        .
                .fnend
                .size    HardFault_Handler, . - HardFault_Handler

                .thumb_func
                .type    Default_Handler, %function
                .weak    Default_Handler
                .fnstart
Default_Handler:
                b        .
                .fnend
                .size    Default_Handler, . - Default_Handler

/* Macro to define default exception/interrupt handlers.
 * Default handler are weak symbols with an endless loop.
 * They can be overwritten by real handlers.
 */
                .macro   Set_Default_Handler  Handler_Name
                .weak    \Handler_Name
                .set     \Handler_Name, Default_Handler
                .endm


/* Default exception/interrupt handler */

                Set_Default_Handler  NMI_Handler
                Set_Default_Handler  MemManage_Handler
                Set_Default_Handler  BusFault_Handler
                Set_Default_Handler  UsageFault_Handler
                Set_Default_Handler  SecureFault_Handler
                Set_Default_Handler  SVC_Handler
                Set_Default_Handler  DebugMon_Handler
                Set_Default_Handler  PendSV_Handler
                Set_Default_Handler  SysTick_Handler

                /* Interrupts */
                Set_Default_Handler  NSWDT_RST_Handler
                Set_Default_Handler  NSWDT_Handler
                Set_Default_Handler  LPTIM_Handler
                Set_Default_Handler  TIM0_Handler
                Set_Default_Handler  TIM1_Handler
                Set_Default_Handler  DTIM_Handler
                Set_Default_Handler  MHU0_Handler
                Set_Default_Handler  MHU1_Handler
                Set_Default_Handler  CRYPTO_Handler
                Set_Default_Handler  MPC_Handler
                Set_Default_Handler  PPC_Handler
                Set_Default_Handler  MSC_Handler
                Set_Default_Handler  BRG_Handler
                Set_Default_Handler  ICACHE_Handler
                Set_Default_Handler  SYS_PPU_Handler
                Set_Default_Handler  CPU0_PPU_Handler
                Set_Default_Handler  CPU1_PPU_Handler
                Set_Default_Handler  CRYPTO_PPU_Handler
                Set_Default_Handler  RAM0_PPU_Handler
                Set_Default_Handler  RAM1_PPU_Handler
                Set_Default_Handler  RAM2_PPU_Handler
                Set_Default_Handler  RAM3_PPU_Handler
                Set_Default_Handler  DEBUG_PPU_Handler
                Set_Default_Handler  CPUCTIIRQ0_Handler
                Set_Default_Handler  CPUCTIIRQ1_Handler
                Set_Default_Handler  UART0_Handler
                Set_Default_Handler  UART1_Handler
                Set_Default_Handler  UART2_Handler
                Set_Default_Handler  UART3_Handler
                Set_Default_Handler  SPI0_Handler
                Set_Default_Handler  SPI1_Handler
                Set_Default_Handler  SPI2_Handler
                Set_Default_Handler  I2C0_Handler
                Set_Default_Handler  I2C1_Handler
                Set_Default_Handler  I2S_Handler
                Set_Default_Handler  GPIO0_S_Handler
                Set_Default_Handler  GPIO1_S_Handler
                Set_Default_Handler  GPIO2_S_Handler
                Set_Default_Handler  GPIO3_S_Handler
                Set_Default_Handler  CAN_Handler
                Set_Default_Handler  PWM_Handler
                Set_Default_Handler  VTU0_Handler
                Set_Default_Handler  VTU1_Handler
                Set_Default_Handler  FCACHE_Handler
                Set_Default_Handler  FCTR_Handler
                Set_Default_Handler  QSPI_Handler
                Set_Default_Handler  GNSS_Handler
                Set_Default_Handler  DMA0_Handler
                Set_Default_Handler  DMA1_Handler
                Set_Default_Handler  SDMMC_Handler
                Set_Default_Handler  USB_Handler
                Set_Default_Handler  JTM_Handler
                Set_Default_Handler  GMS_URB_Handler
                Set_Default_Handler  GMS_DMA_Handler
                Set_Default_Handler  GMS_PPU_Handler
                Set_Default_Handler  GNSS_PPU_Handler
                Set_Default_Handler  RWC_WKUP_Handler
                Set_Default_Handler  RWC_TICK_Handler
                Set_Default_Handler  RWC_ALARM_Handler
                Set_Default_Handler  DMA0_CH0_Handler
                Set_Default_Handler  DMA0_CH1_Handler
                Set_Default_Handler  DMA0_CH2_Handler
                Set_Default_Handler  DMA0_CH3_Handler
                Set_Default_Handler  DMA0_CH4_Handler
                Set_Default_Handler  DMA0_CH5_Handler
                Set_Default_Handler  DMA0_CH6_Handler
                Set_Default_Handler  DMA0_CH7_Handler
                Set_Default_Handler  DMA1_CH0_Handler
                Set_Default_Handler  DMA1_CH1_Handler
                Set_Default_Handler  DMA1_CH2_Handler
                Set_Default_Handler  DMA1_CH3_Handler
                Set_Default_Handler  DMA1_CH4_Handler
                Set_Default_Handler  DMA1_CH5_Handler
                Set_Default_Handler  DMA1_CH6_Handler
                Set_Default_Handler  DMA1_CH7_Handler
                Set_Default_Handler  VMON_Handler
                Set_Default_Handler  SDMMC_WKUP_Handler
                Set_Default_Handler  GPIO0_NS_Handler
                Set_Default_Handler  GPIO1_NS_Handler
                Set_Default_Handler  GPIO2_NS_Handler
                Set_Default_Handler  GPIO3_NS_Handler
                Set_Default_Handler  GPIO0_ACC_Handler
                Set_Default_Handler  GPIO1_ACC_Handler
                Set_Default_Handler  GPIO2_ACC_Handler
                Set_Default_Handler  GPIO3_ACC_Handler

                .globl __aeabi_unwind_cpp_pr0
                .globl __aeabi_unwind_cpp_pr1
__aeabi_unwind_cpp_pr0:
__aeabi_unwind_cpp_pr1:
    b __aeabi_unwind_cpp_pr0
                .end
