/**
 * Copyright (c) 2021-2025, RnD Center «ELVEES», JSC
 * All rights reserved.
 * Contacts: https://elvees.ru, support@elvees.com
 *
 * Project:		SDK
 *
 * SPDX-License-Identifier: BSD-3-Clause
 *
 *
 * Разрешается повторное распространение и использование как в виде исходного кода, так и в объектном коде, 
 * с изменениями или без, при соблюдении следующих условий:
 * 
 * 1. При повторном распространении исходного кода должно оставаться указанное выше уведомление об авторском праве, 
 * этот список условий и последующий отказ от гарантий.
 * 2. При повторном распространении двоичного кода должна сохраняться указанная выше информация об авторском праве, 
 * этот список условий и последующий отказ от гарантий в документации и/или в других материалах, поставляемых при 
 * распространении.
 * 3. Ни название организации, ни имена её сотрудников не могут быть использованы в качестве поддержки или 
 * продвижения продуктов, основанных на этом ПО без предварительного письменного разрешения.
 * ЭТА ПРОГРАММА ПРЕДОСТАВЛЕНА ВЛАДЕЛЬЦАМИ АВТОРСКИХ ПРАВ И/ИЛИ ДРУГИМИ СТОРОНАМИ «КАК ОНА ЕСТЬ» 
 * БЕЗ КАКОГО-ЛИБО ВИДА ГАРАНТИЙ, ВЫРАЖЕННЫХ ЯВНО ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ИМИ, 
 * ПОДРАЗУМЕВАЕМЫЕ ГАРАНТИИ КОММЕРЧЕСКОЙ ЦЕННОСТИ И ПРИГОДНОСТИ ДЛЯ КОНКРЕТНОЙ ЦЕЛИ. НИ В КОЕМ СЛУЧАЕ 
 * НИ ОДИН ВЛАДЕЛЕЦ АВТОРСКИХ ПРАВ И НИ ОДНО ДРУГОЕ ЛИЦО, КОТОРОЕ МОЖЕТ ИЗМЕНЯТЬ И/ИЛИ ПОВТОРНО 
 * РАСПРОСТРАНЯТЬ ПРОГРАММУ, КАК БЫЛО СКАЗАНО ВЫШЕ, НЕ НЕСЁТ ОТВЕТСТВЕННОСТИ, ВКЛЮЧАЯ ЛЮБЫЕ ОБЩИЕ, 
 * СЛУЧАЙНЫЕ, СПЕЦИАЛЬНЫЕ ИЛИ ПОСЛЕДОВАВШИЕ УБЫТКИ, ВСЛЕДСТВИЕ ИСПОЛЬЗОВАНИЯ ИЛИ НЕВОЗМОЖНОСТИ ИСПОЛЬЗОВАНИЯ ПРОГРАММЫ 
 * (ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ПОТЕРЕЙ ДАННЫХ, ИЛИ ДАННЫМИ, СТАВШИМИ НЕПРАВИЛЬНЫМИ, ИЛИ ПОТЕРЯМИ, 
 * ПРИНЕСЕННЫМИ ИЗ-ЗА ВАС ИЛИ ТРЕТЬИХ ЛИЦ, ИЛИ ОТКАЗОМ ПРОГРАММЫ РАБОТАТЬ СОВМЕСТНО С ДРУГИМИ ПРОГРАММАМИ), 
 * ДАЖЕ ЕСЛИ ТАКОЙ ВЛАДЕЛЕЦ ИЛИ ДРУГОЕ ЛИЦО БЫЛИ ИЗВЕЩЕНЫ О ВОЗМОЖНОСТИ ТАКИХ УБЫТКОВ.
 *
 *
 * Redistribution and use in source and binary forms, with or without modification, are permitted provided 
 * that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this list of conditions 
 * and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions 
 * and the following disclaimer in the documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the copyright holder nor the names of its contributors may be used to endorse 
 * or promote products derived from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, 
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED 
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */




#ifndef HAL_DEVICE_H
#define HAL_DEVICE_H

#ifndef ELIOT1M
#include "ELIOT1.h"
#else
#include "ELIOT1m.h"
#endif

#include "hal_mhu.h"
#include "hal_sdmmc_cfg.h"

#ifdef MBED_OS_ELIOT1
#undef QSPI
#undef CAN
#undef SPI
#undef I2C
#endif

extern const sdmmc_port_cfg_t board_sdmmc_cfg;
#define SDMMC_CFG (&board_sdmmc_cfg)

/*!
 * @brief Максимальная разрядность данных для SPI модулей
 */
#define SPI_UNITS_DATA_WIDTH { 32, 32, 16 }

/*!
 * @brief Режим работы модуля (задан аппаратно)
 */
#define SPI_UNITS_TYPE { Master, Master, Slave }

/*!
 * @brief Версия контроллера QSPI
 */
#define QSPI_DRIVER_VERSION_2_0_0

/*!
 * @brief Использование задержек для вычислений таймаутов в драйвере QSPI
 */
extern void BOARD_Udelay(uint32_t us);
#define QSPI_UDELAY(x) BOARD_Udelay(x)

/*!
 * @brief Отображение содержимого флеш-памяти на общее адресное пространство.
 */
#define QSPI_XIP_MEM                   (0x08000000)

/*!
 * @name Параметры встроенной FLASH-памяти.
 * @{
 */

#define FLASH_BASE_ADDR                     (0x00000000U)           /*!< Начальный адрес FLASH-памяти. */
#define FLASH_SECURE_MODE                   (0x10000000U)           /*!< SECURE-доступ к FLASH-памяти. */
#define FLASH_ERASE_DATA                    (0xFFFFFFFF)            /*!< Данные, записываемые в ячейку FLASH-памяти после стирания. */
#define FLASH_PAGE_SIZE_IN_BYTE             (8192U)                 /*!< Количество байт в одной странице FLASH-памяти. */
#define FLASH_WORD_SIZE_IN_BYTE             (4U)                    /*!< Размер слова в байтах. */
#define FLASH_ADDR_Msk                      (0x003FFFFFU)           /*!< Адрес, определяется первыми 22 битами. */
#define FLASH_PAGE_ALIGN_Msk                (0x00001FFFU)           /*!< Маска, для проверки выравнивания на границу страницы. */
#define FLASH_WORD_ALIGN_Msk                (0x00000003U)           /*!< Маска, для проверки выравнивания на границу слова. */

#define FLASH_LVE_MAX_FREQ                  (25000000U)             /*!< Макс. частота процессора, допустимая для работы в режиме LVE. */
#define FLASH_NO_READ_LATENCY_MAX_FREQ      (40000000U)             /*!< Макс. частота процессора, для чтения FLASH без задержки. */

#define FLASH_MAIN_REGION_SIZE_IN_PAGE      (80U)                   /*!< Количество страниц памяти в основном разделе. */
#define FLASH_MAIN_REGION_SIZE_IN_BYTE \
    (FLASH_MAIN_REGION_SIZE_IN_PAGE * FLASH_PAGE_SIZE_IN_BYTE)      /*!< Размер основного раздела в байтах. */

#define FLASH_SYSTEM_REGION_SIZE_IN_PAGE    (4U)                    /*!< Количество страниц системного раздела. */
#define FLASH_SYSTEM_REGION_SIZE_IN_BYTE \
    (FLASH_SYSTEM_REGION_SIZE_IN_PAGE * FLASH_PAGE_SIZE_IN_BYTE)    /*!< Размер системного раздела в байтах. */
#define FLASH_SYSTEM_REGION_OFFSET          (0x00200000U)           /*!< Смещение системного раздела относительно основного. */

#define PWM_CHANNEL_COUNT 4
#define PWM_UNITS { (PWM_Type *)0x40111000, (PWM_Type *)0x40111100, (PWM_Type *)0x40111200, (PWM_Type *)0x40111300 }

/*!
 * @}
 */

#endif /* HAL_DEVICE_H */
