#!/usr/bin/env bash

set -o pipefail
set -e

cd `dirname $0`

root_dir=$(pwd)
script_dir=$root_dir/src/lib

if [ ! -d $root_dir/src ]; then
    git clone ssh://git@warlock.elvees.com:2222/external_middleware/embeddedcli.git $root_dir/src
fi

cd $script_dir

if [[ $(uname -s) == MINGW* ]] || [[ $(uname -s) == MSYS* ]] && [[ $OS == Windows_NT ]]; then
    python build-shl.py
else
    python3 build-shl.py
fi

cd $root_dir
