# Обзор

Демонстрация работы драйвера GPIO, вывод информации через UART при разных состояниях кнопки,
управление светодиодами на плате.

## Описание примера

Программа информирует о состоянии пользовательской кнопки Test через UART и переключением светодиода на плате.

## Необходимый Toolchain

- Embedded GCC ARM 10.3.1.

## Требования к аппаратному обеспечению для запуска примера

- Type-C USB кабель;
- плата с ELIOT1m\_MO;
- персональный компьютер;

## Работа с программой

- добавить путь до **arm toolchain** в переменную **PATH**;
- подключиться к UART;
- вызвать скрипт **build.sh**
- выполнить команду `arm-none-eabi-gdb-py -x eliot1.gdbinit` для загрузки;
  программы на плату;
- запустить программу на исполнение с помощью gdb команды `continue`.

## Подготовка к работе

1. Подключите все.
2. Откройте последовательный терминал (пример Putty, Minicom) со следующими
   настройками:
   - скорость 115200 бод;
   - 8 бит данных;
   - нет паритета;
   - один стоповый бит;
   - нет контроля потока.

## Вывод программы после запуска

При успешном запуске на терминале будет отображаться сообщение:

```bash
    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    ELIOT1M_MO is enabled
    Program will send button`s status
    Button was pressed
    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
```

Периодически будет мигать светодиод на плате, другой светодиод будет включаться/отключаться от нажатия кнопки.
