# Обзор

Программа демонстрирует работу таймера реального времени.

## Описание примера

В примере производится настройка платы, консоли вывода, таймера реального
времени. В консоль вывода попадает информация о текущем времени каждую секунду.

## Необходимый Toolchain

- Embedded GCC ARM 10.3.1.

## Требования к аппаатному обеспечению для запуска примера

Для запуска теста необходимо нижеперечисленное оборудование:

- кабель Type-C USB;
- плата ELIoT1m\_MO;
- персональный компьютер.

## Работа с программой

- добавить путь до **arm toolchain** в переменную **PATH**;
- вызвать скрипт **build.sh**;
- выполнить команду `arm-none-eabi-gdb-py -x eliot1.gdbinit` для загрузки
  программы на плату;
- запустить программу на исполнение с помощью gdb команды `continue`.

## Подготовка к работе

Процесс запуска на плате:

1. Подключите плату.
2. Откройте последовательный терминал (пример Putty, Minicom) со следующими
   настройками:
   - скорость 115200 бод;
   - 8 бит данных;
   - нет паритета;
   - один стоповый бит;
   - нет контроля потока.
3. Запустите программу.

## Вывод программы после запуска

При успешном запуске будет отображаться на терминале:

```bash
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
RWC example start
SysClk = 50000000
T: 184549520
T: 184549521
T: 184549522
T: 184549523
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
```
