#!/usr/bin/env bash

set -o pipefail
set -e

root_dir=`dirname $0`
cd $root_dir
root_dir=$(pwd)

hal_dir="$root_dir/../../../../../.."
example_dir="$root_dir/../../"

toolchain_file="$hal_dir/tools/cmake_toolchain_files/armgcc.cmake"
bsp_dir="$hal_dir/boards/eliot1m_mo_cfg/armgcc/bsp_core"

cmake_build() {
    script_dir="${example_dir}/cm33_core${1}/armgcc"
    build_dir="${example_dir}/cm33_core${1}/build"

    # build bsp_core
    bash "${bsp_dir}${1}/build.sh"

    # create build dir
    if [[ -d $build_dir ]]; then
        rm -rf "${build_dir}"
    fi

    mkdir "${build_dir}"
    cd "${build_dir}"

    cmake -G "Unix Makefiles" \
        -DCMAKE_TOOLCHAIN_FILE="${toolchain_file}" \
        "${script_dir}"
    make
}

# build for Core0
cmake_build 0

# build for Core1
cmake_build 1

cp -fv core1_dsp_test.elf ../../cm33_core0/build/core1_dsp_test.elf
cp -fv core1_dsp_test.dis ../../cm33_core0/build/core1_dsp_test.dis
