#!/usr/bin/env bash

set -o pipefail
set -e

root_dir=`dirname $0`
cd $root_dir
root_dir=$(pwd)

hal_dir="$root_dir/../../../../../.."

build_dir="$root_dir/../build"
script_dir="$root_dir/../armgcc"
toolchain_file="$hal_dir/tools/cmake_toolchain_files/armgcc.cmake"
bsp_dir="$hal_dir/boards/eliot1m_mo_cfg/armgcc/bsp_core"

function cmake_build {
#build bsp_core
bash $bsp_dir$1/build.sh

#create build dir
rm -rf "${build_dir}"
mkdir -p "${build_dir}"
cd "${build_dir}"

cmake -G "Unix Makefiles" \
    -DCMAKE_TOOLCHAIN_FILE="${toolchain_file}" \
    "${script_dir}"
make
}

#Core0
build_dir="$root_dir/../build"
script_dir="$root_dir/../armgcc"
cmake_build 0

#Core1
build_dir="$root_dir/../../cm33_core1/build"
script_dir="$root_dir/../../cm33_core1/armgcc"
cmake_build 1

cp -fv core1_dsp_test.elf ../../cm33_core0/build/core1_dsp_test.elf
cp -fv core1_dsp_test.dis ../../cm33_core0/build/core1_dsp_test.dis

