/**
 * Copyright (c) 2021-2025, RnD Center «ELVEES», JSC
 * All rights reserved.
 * Contacts: https://elvees.ru, support@elvees.com
 *
 * Project:		SDK
 *
 * SPDX-License-Identifier: BSD-3-Clause
 *
 *
 * Разрешается повторное распространение и использование как в виде исходного кода, так и в объектном коде, 
 * с изменениями или без, при соблюдении следующих условий:
 * 
 * 1. При повторном распространении исходного кода должно оставаться указанное выше уведомление об авторском праве, 
 * этот список условий и последующий отказ от гарантий.
 * 2. При повторном распространении двоичного кода должна сохраняться указанная выше информация об авторском праве, 
 * этот список условий и последующий отказ от гарантий в документации и/или в других материалах, поставляемых при 
 * распространении.
 * 3. Ни название организации, ни имена её сотрудников не могут быть использованы в качестве поддержки или 
 * продвижения продуктов, основанных на этом ПО без предварительного письменного разрешения.
 * ЭТА ПРОГРАММА ПРЕДОСТАВЛЕНА ВЛАДЕЛЬЦАМИ АВТОРСКИХ ПРАВ И/ИЛИ ДРУГИМИ СТОРОНАМИ «КАК ОНА ЕСТЬ» 
 * БЕЗ КАКОГО-ЛИБО ВИДА ГАРАНТИЙ, ВЫРАЖЕННЫХ ЯВНО ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ИМИ, 
 * ПОДРАЗУМЕВАЕМЫЕ ГАРАНТИИ КОММЕРЧЕСКОЙ ЦЕННОСТИ И ПРИГОДНОСТИ ДЛЯ КОНКРЕТНОЙ ЦЕЛИ. НИ В КОЕМ СЛУЧАЕ 
 * НИ ОДИН ВЛАДЕЛЕЦ АВТОРСКИХ ПРАВ И НИ ОДНО ДРУГОЕ ЛИЦО, КОТОРОЕ МОЖЕТ ИЗМЕНЯТЬ И/ИЛИ ПОВТОРНО 
 * РАСПРОСТРАНЯТЬ ПРОГРАММУ, КАК БЫЛО СКАЗАНО ВЫШЕ, НЕ НЕСЁТ ОТВЕТСТВЕННОСТИ, ВКЛЮЧАЯ ЛЮБЫЕ ОБЩИЕ, 
 * СЛУЧАЙНЫЕ, СПЕЦИАЛЬНЫЕ ИЛИ ПОСЛЕДОВАВШИЕ УБЫТКИ, ВСЛЕДСТВИЕ ИСПОЛЬЗОВАНИЯ ИЛИ НЕВОЗМОЖНОСТИ ИСПОЛЬЗОВАНИЯ ПРОГРАММЫ 
 * (ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ПОТЕРЕЙ ДАННЫХ, ИЛИ ДАННЫМИ, СТАВШИМИ НЕПРАВИЛЬНЫМИ, ИЛИ ПОТЕРЯМИ, 
 * ПРИНЕСЕННЫМИ ИЗ-ЗА ВАС ИЛИ ТРЕТЬИХ ЛИЦ, ИЛИ ОТКАЗОМ ПРОГРАММЫ РАБОТАТЬ СОВМЕСТНО С ДРУГИМИ ПРОГРАММАМИ), 
 * ДАЖЕ ЕСЛИ ТАКОЙ ВЛАДЕЛЕЦ ИЛИ ДРУГОЕ ЛИЦО БЫЛИ ИЗВЕЩЕНЫ О ВОЗМОЖНОСТИ ТАКИХ УБЫТКОВ.
 *
 *
 * Redistribution and use in source and binary forms, with or without modification, are permitted provided 
 * that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this list of conditions 
 * and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions 
 * and the following disclaimer in the documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the copyright holder nor the names of its contributors may be used to endorse 
 * or promote products derived from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, 
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED 
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */




/*!
 * @defgroup qspi_driver Драйвер модуля QSPI
 *
 * @brief Драйвер контроллера QSPI
 *
 * Работа контроллера QSPI с флеш-памятью NOR.
 */

/*!
 * @addtogroup qspi_driver
 * @{
 */

/*!
 * @file hal_qspi_nor_flash.h
 *
 * @brief Интерфейс драйвера модуля QSPI-NOR-FLASH
 */

#ifndef HAL_QSPI_NOR_FLASH_H
#define HAL_QSPI_NOR_FLASH_H

#ifdef __cplusplus
extern "C" {
#endif

#include "hal_common.h"
#include "hal_nor_flash.h"
#include "hal_qspi.h"

/*!
 * @brief Коды операций микросхемы флеш-памяти
 */
enum _serial_nor_command {
    NOR_CmdInvalid                 = 0x00U, /*!< Неверный код операции */
    NOR_CmdWriteStatus             = 0x01U, /*!< WRSR: Запись в статусный регистр */
    NOR_CmdWriteSecStatus_31       = 0x31U, /*!< WRSR: Запись во второй статусный регистр */
    NOR_CmdWriteSecStatus_3E       = 0x3EU, /*!< WRSR: Запись во второй статусный регистр */
    NOR_CmdWriteMemory             = 0x02U, /*!< WRITE: Запись байта/страницы в массив флеш-памяти с адресом меньше четырех байт */
    NOR_CmdWriteMemoryA32          = 0x12U, /*!< 4PP: Запись байта/страницы в массив флеш-памяти с адресом четыре байта */
    NOR_CmdWriteEnable             = 0x06U, /*!< WREN: Установка бита Write Enable Latch */
    NOR_CmdWriteDisable            = 0x04U, /*!< WRDI: Сброс бита Write Enable Latch */
    NOR_CmdReadStatus              = 0x05U, /*!< RDSR: Чтение статусного регистра */
    NOR_CmdReadSecStatus_35        = 0x35U, /*!< RDSR: Чтение второго статусного регистра */
    NOR_CmdReadSecStatus_3F        = 0x3FU, /*!< RDSR: Чтение второго статусного регистра */
    NOR_CmdReadMemory              = 0x03U, /*!< READ: Чтение данных из массива флеш-памяти с адресом меньше четырех байт */
    NOR_CmdReadMemoryA32           = 0x13U, /*!< 4READ: Чтение данных из массива флеш-памяти с адресом четыре байта */
    NOR_CmdReadMemorySDR_1_1_1     = 0x0BU, /*!< READ: Чтение данных из массива флеш-памяти в режиме 1_1_1 */
    NOR_CmdReadMemorySDR_1_1_2     = 0x3BU, /*!< READ: Чтение данных из массива флеш-памяти в режиме 1_1_2 */
    NOR_CmdReadMemorySDR_1_2_2     = 0xBBU, /*!< READ: Чтение данных из массива флеш-памяти в режиме 1_2_2 */
    NOR_CmdReadMemorySDR_1_1_4     = 0x6BU, /*!< READ: Чтение данных из массива флеш-памяти в режиме 1_1_4 */
    NOR_CmdReadMemorySDR_1_4_4     = 0xEBU, /*!< READ: Чтение данных из массива флеш-памяти в режиме 1_4_4 */
    NOR_CmdReadMemorySDR_1_4_4_A32 = 0xECU, /*!< READ: Чтение данных из массива флеш-памяти в режиме 1_4_4 с адресом четыре байта */
    NOR_CmdReadMemorySDR_1_1_4_A32 = 0x6CU, /*!< READ: Чтение данных из массива флеш-памяти в режиме 1_1_4 с адресом четыре байта */
    NOR_CmdEraseChipNor            = 0x60U, /*!< CE: Очистка всего массива флеш-памяти */
    NOR_CmdEraseChip               = 0xC7U, /*!< CE: Очистка всего массива флеш-памяти */
    NOR_CmdErasePage               = 0x42U, /*!< PE: Очистка страницы */
    NOR_CmdEraseSector4KB          = 0x20U, /*!< SE4KB: Очистка сектора размером 4КБ */
    NOR_CmdEraseSector32KB         = 0x52U, /*!< SE32KB: Очистка сектора размером 32 КБ */
    NOR_CmdEraseSector             = 0xD8U, /*!< SE: Очистка сектора */
    NOR_CmdEraseSector4KBA32       = 0x21U, /*!< 4SE4KB: Очистка сектора размером 4КБ с адресом четыре байта */
    NOR_CmdEraseSectorA32          = 0xDCU, /*!< 4SE: Очистка сектора с адресом четыре байта */
};

/*!
 * @brief Требования для включение режима Quad
 *
 * Указывает смещение бита Quad Enable.
 */
enum {
    NOR_QuadModeNotConfig            = 0, /*!< Режим Quad не сконфигурирован */
    NOR_QuadModeStatusReg1_Bit6      = 1, /*!< Статусный регистр 1 бит 6 */
    NOR_QuadModeStatusReg2_Bit1      = 2, /*!< Статусный регистр 2 бит 1 */
    NOR_QuadModeStatusReg2_Bit7      = 3, /*!< Статусный регистр 2 бит 7 */
    NOR_QuadModeStatusReg2_Bit1_0x31 = 4, /*!< Статусный регистр 2 бит 1 (специальная команда) */
};

/*!
 * @brief Конфигурационный блок для режима Quad
 */
typedef struct _qspi_nor_config {
    bool is_quad_need_enable;      /*!< Установка Quad Enable: 1 - Установка, 0 - Сброс */
    bool write_two_status_bytes;   /*!< Необходимо ли запись двух статусных регистров при установке бита Quad Enable */
    uint8_t quad_enable_command;   /*!< Код операции для установки Quad Enable */
    uint8_t quad_enable_bit_shift; /*!< Смещение бита Quad Enable */
    uint8_t quad_read_command;     /*!< Команда чтения в режиме Quad*/
} qspi_nor_config_t;

/*!
 * @brief Формат команды QSPI
 */
typedef enum _qspi_command_format {
    QSPI_CommandAllSerial = 0x0,     /*!< Все составляющие команды передаются последовательно */
    QSPI_CommandDataQuad  = 0x1U,    /*!< Только данные передаются в режиме Quad */
    QSPI_CommandOpcodeSerial = 0x2U, /*!< Только код операции передается последовательно */
} qspi_command_format_t;

/*!
 * @brief Первоначальная конфигурация QSPI
 */
typedef struct _qspi_nor_init_config {
    qspi_command_format_t cmd_format; /*!< Формат команды для операции чтения */
    uint32_t quad_mode_setting;       /*!< Требования для включение режима Quad */
} qspi_nor_init_config_t;

/*!
 * @brief Тип команды QSPI
 */
typedef enum _qspi_command_type {
    QSPI_CommandOpcodeOnly             = 0x1U, /*!< Команда имеет только код операции */
    QSPI_CommandOpcodeAddrOneByte      = 0x2U, /*!< Команда имеет код операции и один байт адреса */
    QSPI_CommandOpcodeAddrTwoBytes     = 0x3U, /*!< Команда имеет код операции и два байта адреса */
    QSPI_CommandOpcodeAddrThreeBytes   = 0x4U, /*!< Команда имеет код операции и три байта адреса */
    QSPI_CommandOpcodeAddrFourBytes    = 0x5U, /*!< Команда имеет код операции и четыре байта адреса */
    QSPI_CommandNoOpcodeAddrThreeBytes = 0x6U, /*!< Команда не имеет кода операции и имеет три байта адреса */
    QSPI_CommandNoOpcodeAddrFourBytes  = 0x7U, /*!< Команда не имеет кода операции и имеет четыре байта адреса */
} qspi_command_type_t;

/*!
 * @brief Контекст драйвера NOR Flash
 */
typedef struct _qspi_nor_handle {
    qspi_command_type_t command_type;      /*!< Тип кода операции и адреса */
    qspi_command_format_t read_cmd_format; /*!< Формат команды для чтения */
    uint8_t intermediate_len;              /*!< Количество промежуточных байтов */
    nor_command_set_t command_set;         /*!< Набор базовых команд */
} qspi_nor_handle_t;

#ifdef __cplusplus
}
#endif

#endif /* HAL_QSPI_NOR_FLASH_H */

/*!
 * @}
 */
