/**
 * Copyright (c) 2021-2025, RnD Center «ELVEES», JSC
 * All rights reserved.
 * Contacts: https://elvees.ru, support@elvees.com
 *
 * Project:		SDK
 *
 * SPDX-License-Identifier: BSD-3-Clause
 *
 *
 * Разрешается повторное распространение и использование как в виде исходного кода, так и в объектном коде, 
 * с изменениями или без, при соблюдении следующих условий:
 * 
 * 1. При повторном распространении исходного кода должно оставаться указанное выше уведомление об авторском праве, 
 * этот список условий и последующий отказ от гарантий.
 * 2. При повторном распространении двоичного кода должна сохраняться указанная выше информация об авторском праве, 
 * этот список условий и последующий отказ от гарантий в документации и/или в других материалах, поставляемых при 
 * распространении.
 * 3. Ни название организации, ни имена её сотрудников не могут быть использованы в качестве поддержки или 
 * продвижения продуктов, основанных на этом ПО без предварительного письменного разрешения.
 * ЭТА ПРОГРАММА ПРЕДОСТАВЛЕНА ВЛАДЕЛЬЦАМИ АВТОРСКИХ ПРАВ И/ИЛИ ДРУГИМИ СТОРОНАМИ «КАК ОНА ЕСТЬ» 
 * БЕЗ КАКОГО-ЛИБО ВИДА ГАРАНТИЙ, ВЫРАЖЕННЫХ ЯВНО ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ИМИ, 
 * ПОДРАЗУМЕВАЕМЫЕ ГАРАНТИИ КОММЕРЧЕСКОЙ ЦЕННОСТИ И ПРИГОДНОСТИ ДЛЯ КОНКРЕТНОЙ ЦЕЛИ. НИ В КОЕМ СЛУЧАЕ 
 * НИ ОДИН ВЛАДЕЛЕЦ АВТОРСКИХ ПРАВ И НИ ОДНО ДРУГОЕ ЛИЦО, КОТОРОЕ МОЖЕТ ИЗМЕНЯТЬ И/ИЛИ ПОВТОРНО 
 * РАСПРОСТРАНЯТЬ ПРОГРАММУ, КАК БЫЛО СКАЗАНО ВЫШЕ, НЕ НЕСЁТ ОТВЕТСТВЕННОСТИ, ВКЛЮЧАЯ ЛЮБЫЕ ОБЩИЕ, 
 * СЛУЧАЙНЫЕ, СПЕЦИАЛЬНЫЕ ИЛИ ПОСЛЕДОВАВШИЕ УБЫТКИ, ВСЛЕДСТВИЕ ИСПОЛЬЗОВАНИЯ ИЛИ НЕВОЗМОЖНОСТИ ИСПОЛЬЗОВАНИЯ ПРОГРАММЫ 
 * (ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ПОТЕРЕЙ ДАННЫХ, ИЛИ ДАННЫМИ, СТАВШИМИ НЕПРАВИЛЬНЫМИ, ИЛИ ПОТЕРЯМИ, 
 * ПРИНЕСЕННЫМИ ИЗ-ЗА ВАС ИЛИ ТРЕТЬИХ ЛИЦ, ИЛИ ОТКАЗОМ ПРОГРАММЫ РАБОТАТЬ СОВМЕСТНО С ДРУГИМИ ПРОГРАММАМИ), 
 * ДАЖЕ ЕСЛИ ТАКОЙ ВЛАДЕЛЕЦ ИЛИ ДРУГОЕ ЛИЦО БЫЛИ ИЗВЕЩЕНЫ О ВОЗМОЖНОСТИ ТАКИХ УБЫТКОВ.
 *
 *
 * Redistribution and use in source and binary forms, with or without modification, are permitted provided 
 * that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this list of conditions 
 * and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions 
 * and the following disclaimer in the documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the copyright holder nor the names of its contributors may be used to endorse 
 * or promote products derived from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, 
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED 
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */




/*!
 * @addtogroup sdmmc_driver
 * @{
 */

/*!
 * @file hal_sdmmc_cfg.h
 *
 * @brief Интерфейс конфигурации модуля SDMMC
 */
#ifndef HAL_SDMMC_CFG_H
#define HAL_SDMMC_CFG_H

#include <stdint.h>

/*!
 * @brief Конфигурация выводов контроллера SDMMC
 */
typedef struct {
    uint8_t pull_en;     /*!< Включение программных резистивных подтяжек на сигнальных выводах */
    uint8_t max_current; /*!< Максимальный ток выводов */
    uint8_t CK;          /*!< Вывод выходной частоты */
    uint8_t CMD;         /*!< Вывод управления */
    uint8_t D0;          /*!< Вывод данных бит 0 */
    uint8_t D1;          /*!< Вывод данных бит 1 */
    uint8_t D2;          /*!< Вывод данных бит 2 */
    uint8_t D3;          /*!< Вывод данных бит 3 */
    uint8_t D4;          /*!< Вывод данных бит 4 */
    uint8_t D5;          /*!< Вывод данных бит 5 */
    uint8_t D6;          /*!< Вывод данных бит 6 */
    uint8_t D7;          /*!< Вывод данных бит 7 */
    uint8_t CD;          /*!< Вывод обнаружения карты SD */
} sdmmc_cfg_pin_map;

/*!
 * @brief Конфигурация контроллера SDMMC
 */
typedef struct {
    uint32_t reg_base[2];       /*!< Базовые адреса модулей SDMMC */
    uint32_t slot_count;        /*!< Количество слотов под карту */
    uint8_t  slot_type;         /*!< Тип слота карты карты */
    uint8_t  emmc_8bit_en;      /*!< Включение 8-битного режима (только для MMC) */
    uint8_t  hs_en;             /*!< Включение режима High Speed */
    uint8_t  sd_uhs_mode;       /*!< Выбор режима работы для UHS-I */
    uint32_t freq_out_init;     /*!< Выходная частота карты SD/MMC во время инициализации */
    uint32_t freq_out;          /*!< Рабочая выходная частота карты SD/MMC */
    uint32_t timeout_cd;        /*!< Максимальное время ожидания определения наличия карты */
    uint32_t timeout_init;      /*!< Максимальное время ожидания инициализации карты */
    void (*delay_us)(uint32_t); /*!< Указатель на функцию задержки в мкс */
    sdmmc_cfg_pin_map pin_map; /*!< Карта выводов SDMMC */
} sdmmc_port_cfg_t;

#endif /* HAL_SDMMC_CFG_H */

/*!
 * @}
 */
