#!/usr/bin/env bash

set -o pipefail
set -e

QSPICLK_VALUE=$1
BUILD_TYPE=$2

if [ -z $QSPICLK_VALUE ]; then
    QSPICLK_VALUE=48000000
    BUILD_TYPE=Release
else
    if [ -z $BUILD_TYPE ]; then
        BUILD_TYPE=Release
    fi
fi

cd `dirname $0`

root_dir=$(pwd)

# Build bootloader
bash build.sh $QSPICLK_VALUE $BUILD_TYPE

cd scripts

# Load image to OTP
bash load_image_to_otp.sh ../build/otp_xip_bootloader.bin 0
# Set boot from OTP
bash set_boot_from_otp.sh

cd $root_dir
