
                .syntax  unified
                .arch    armv8-m.main

                .section .vectors, "a"
                .align   2


                .thumb
                .section .text, "ax"
                .align   2

#include "config.h"

                .long    __StackTop                         /* Top of Stack */
                .long    Reset_Handler                      /* 0   -15  Reset Handler */

                .thumb_func
                .type    Reset_Handler, %function
                .globl   Reset_Handler
                .fnstart
Reset_Handler:
                /* Start CLKCTR init */
                ldr      r0, =CLKCTR_BASE

                /* CLKCTR_CFG */
                mov      r1, CLKCTR_CFG
                /* Write to CLKCTR_CFG */
                str      r1, [r0, CLKCTR_CFG_OFFSET]

                /* CLKCTR_PLLCFG */
                mov      r1, CLKCTR_PLLCFG
                str      r1, [r0, CLKCTR_PLLCFG_OFFSET]

                /* SYSCLKDIV */
                mov      r1, CLKCTR_SYSCLKDIV
                str      r1, [r0, CLKCTR_SYSCLKDIV_OFFSET]

                /* QSPICLKDIV */
                mov      r1, CLKCTR_QSPICLKDIV
                str      r1, [r0, CLKCTR_QSPICLKDIV_OFFSET]

                /* QSPI PIN INIT */
                ldr      r0, =IOCTR_BASE

                mov      r2, #0
                mov      r4, #0

                add      r1, r0, IOCTR_PORTD_OFFSET

                movw     r3, IOCTR_PORTD_MODE_REG_L
                movt     r3, IOCTR_PORTD_MODE_REG_H
                
                movt     r4, AFL_REG_VALUE
                movt     r2, AFH_REG_VALUE

                movw     r5, IOCTR_PORTD_DS_REG_L
                movt     r5, IOCTR_PORTD_DS_REG_H

                str      r3, [r1, IOCTR_PORTD_MODE_OFFSET]
                str      r2, [r1, IOCTR_PORTD_AFH_OFFSET]
                str      r4, [r1, IOCTR_PORTD_AFL_OFFSET]
                str      r5, [r1, IOCTR_PORTD_DS_OFFSET]

                /* QSPI XIP INIT */
                ldr      r0, =QSPI_BASE
                mov      r1, #0
                movw     r1, QSPI_XIPCFG_SET_L
                str      r1, [r0, QSPI_XIPCFG_OFFSET]
                movt     r1, QSPI_XIPCFG_SET_H
                str      r1, [r0, QSPI_XIPCFG_OFFSET]

1:
                ldr      r1, [r0, QSPI_XIPCFG_OFFSET]
                and      r1, QSPI_XIPCFG_XIP_EN_OUT_MSK
                cmp      r1, QSPI_XIPCFG_XIP_EN_OUT_MSK
                bne      1b

                /* Fake read */
                ldr      r0, =XIP_BASE
                mov      r2, #0
2:
                ldr      r1, [r0, r2]
                add      r2, #4
                cmp      r2, FAKE_READ_BYTES
                bne      2b

                /* JUMP TO XIP */
                ldr      r2, [r0, #4]
                add      r3, r2, #1
                cmp      r3, #0
                beq      .

                ldr      r1, [r0]
                mov      sp, r1
                msr      psp, r1
                msr      msp, r1
                blx      r2
                b        .
                .fnend
                .size    Reset_Handler, . - Reset_Handler

                .globl __aeabi_unwind_cpp_pr0
                .globl __aeabi_unwind_cpp_pr1
__aeabi_unwind_cpp_pr0:
__aeabi_unwind_cpp_pr1:
    b __aeabi_unwind_cpp_pr0
                .end
