
MEMORY
{
  FLASH     (rxa)   : ORIGIN = 0x10000000, LENGTH = 640K
  FLASH_SYS (rxa)   : ORIGIN = 0x10200000, LENGTH = 32K
  RAM       (rwxa)  : ORIGIN = 0x30000000, LENGTH = 256K
}

ENTRY(Reset_Handler)

SECTIONS
{
    .vectors :
	{
            KEEP(*(.vectors))
	} > FLASH_SYS AT > FLASH_SYS

	.text :
	{
		*(.text*)
		KEEP(*(.eh_frame*))
	} > FLASH_SYS AT > FLASH_SYS

    .rodata :
    {
        *(.rodata .rodata.*)
        BOOT_ADDR = ORIGIN(FLASH);
    } > FLASH_SYS AT > FLASH_SYS

    .ARM.extab :
	{
		*(.ARM.extab* .gnu.linkonce.armextab.*)
	} > FLASH_SYS AT > FLASH_SYS

	__exidx_start = .;
	.ARM.exidx :
	{
		*(.ARM.exidx* .gnu.linkonce.armexidx.*)
        __exidx_end = .;
        __etext = .;
	} > FLASH_SYS AT > FLASH_SYS

	.data :
	{
        __data_start__ = .;
		*(.data*)
		KEEP(*(.jcr*))
		. = ALIGN(4);
        /* All data end */
		__data_end__ = .;
	} > RAM AT > RAM

	.bss :
	{
		. = ALIGN(4);
		__bss_start__ = .;
		*(.bss*)
		*(COMMON)
		. = ALIGN(4);
		__bss_end__ = .;
		end = .;
	} > RAM AT > RAM


	/* .stack_dummy section doesn't contains any symbols. It is only
	 * used for linker to calculate size of stack sections, and assign
	 * values to stack symbols later */
	.stack_dummy (COPY):
	{
		*(.stack*)
        /* Set stack top to end of RAM, and stack limit move down by
        * size of stack_dummy section */
        __StackTop = ORIGIN(RAM) + LENGTH(RAM) - 16;
        __StackLimit = __StackTop - SIZEOF(.stack_dummy);
        PROVIDE(__stack = __StackTop);
	} > RAM AT > RAM

	/* Check if data + heap + stack exceeds RAM limit */
	ASSERT(__StackLimit >= __bss_end__, "region RAM overflowed with stack")
} 
