# Документация

Документация openocd распространяется вместе с архивом по пути:
<openocd_root>/share/doc/openocd/openocd.pdf.

# Запуск openocd

Для подключения к плате можно использовать соответствующий конфигурационный файл.

Пример:

```shell
<openocd_root>/bin/openocd -f interface/cmsis-dap.cfg -f board/eliot1m.cfg
```

Данный конфигурационный файл определяет следующие области памяти для
использования openocd:

- 8KB в конце SRAM2 ( [0x3003e000, 0x30020000) ) для использования при отладке
  CPU0
- 8KB в конце SRAM3 ( [0x3004e000, 0x30030000) ) для использования при отладке
  CPU1

Изменить эти параметры можно после подключения в командной строке GDB:

```
mon ${TARGET}.CPUN configure -work-area-phys $_WORKAREAADDR_CPUN -work-area-size $_WORKAREASIZE_CPUN
```

Где N - номер CPU. Подробнее см. openocd.pdf, 11.3.

Список конфигурационных файлов для плат с eliot1:

- eliot1.cfg - общий конфигурационный файл eliot1 без определения qspi-флеш регионов.
- eliot1_jc4.cfg - конфигурационный для плат jc4 с qspi-флеш регионами.
- eliot1_bub.cfg - конфигурационный для плат bub с qspi-флеш регионами.
- eliot1m.cfg - общий конфигурационный файл eliot1m без определения qspi-флеш регионов.
- eliot1m_bub.cfg -  конфигурационный файл eliot1m для плат bub с qspi-флеш регионами.
- eliot1m_mo.cfg - конфигурационный файл eliot1m для плат mo с qspi-флеш регионами.
  Конфиг адаптера cmsis-dap подключается автоматически.

## Подключение к openocd с удаленной машины

По умолчанию openocd ждет подключения на локальной петле. Для изменения этой
настройки можно использовать команду `bindto`:

```shell
<openocd_root>/bin/openocd -f interface/cmsis-dap.cfg -c 'bindto 0.0.0.0' -f board/eliot1m.cfg
```

Это стоит делать только в безопасной сети. Лучшим подходом является
использование ssh-туннеля:

```shell
[<remote_host> ]# ssh -L 3333:localhost:3333 <openocd_host>
[<openocd_host>]# <openocd_root>/bin/openocd -f interface/cmsis-dap.cfg -f board/eliot1m.cfg
```

Подключение через gdb на удаленной машине по ранее установленному ssh-туннелю:

```shell
[<remote_host> ]# arm-none-eabi-gdb -q
(gdb) target ext :3333
Remote debugging using :3333
```
## Отладка CPU1

Для подключения openocd к CPU1 нужно установить переменную `ENABLE_CPU1`:

```shell
<openocd_root>/bin/openocd -c 'set ENABLE_CPU1 1' -f interface/cmsis-dap.cfg -f board/eliot1m.cfg
```

В сессии GDB для отладки первого ядра нужно задавать порт 3334:

```shell
[<remote_host> ]# arm-none-eabi-gdb -q
(gdb) target ext :3334
Remote debugging using :3334
```

Для одновременной отладки двух ядер нужно запускать две сессии GDB по одной на
каждое ядро.

### CPU_WAIT

После холодного сброса поле CPU1WAIT регистра `SYSCTR_CPUWAIT` выставляется в
единицу. Питание на CPU1 не подаётся.  Поэтому при старте openocd с
`ENABLE_CPU1=1` бит CPU1WAIT снимается отладчиком.

Если есть необходимость отладить программу с остановленным ядром CPU1 после
сброса, то можно в сессии GDB переключить reset_config на теплый сброс
(см. раздел "Сброс" ниже) и установить CPU1WAIT в активное состояние:

```shell
mon reset_config none connect_deassert_srst
mon reset halt
mon mww 0x50021118 2
```

### Cross trigger

При настроенном CTI ядра CPU0 и CPU1 будут переходить в отладочный режим
синхронно. Запуск openocd в этом режиме выглядит следующим образом:

```shell
<openocd_root>/bin/openocd -c 'set USE_CTI 1' -c 'set ENABLE_CPU1 1' -f interface/cmsis-dap.cfg -f board/eliot1m.cfg
```

Также включить режим синхронного останова можно в сессии GDB с использованием
команды `mon eliot1_start_cti`, выключить же - `mon eliot1_stop_cti`.

#### Timer CTI
Для остановки/запуска таймеров (TIM0/TIM1, LPTIM и др.) при остановке/запуске CPU нужно запускать их в режиме Debug.
Устанавливать ENABLE_CPU1 в 1 в этом случае необязательно.


## Тип траспорта (jtag или swd)

По умолчанию openocd с выше указанным конфигом использует swd. Для выбора
транспорта можно использовать команду `transport select <type>`.  Пример:

```shell
<openocd_root>/bin/openocd -f interface/cmsis-dap.cfg -c 'transport select jtag' -f board/eliot1m.cfg
```

## Выбор подключенного устройства

Если к машине, на которой запускается openocd, подключенно несколько устройств
через адаптеры cmsis-dap, то нужное устройство можно выбрать посредством
указания серийного номера адаптера:

```shell
<openocd_root>/bin/openocd -f interface/cmsis-dap.cfg -c 'cmsis_dap_serial 02200201E6661E601B98E3B9' -f board/eliot1m.cfg
```

Для eliot1m_mo серийный номер можно задать через переменную:

```shell
<openocd_root>/bin/openocd -c 'set CMSIS_DAP_SERIAL 02200201E6661E601B98E3B9' -f board/eliot1m_mo.cfg
```

## Сброс

По умолчанию openocd делает "холодный" сброс через поднятие сигнала
SRSTn. Переключиться на использование теплого сброса можно через из GDB-shell
следующим образом:

```shell
# switch to warm reset
mon reset_config none connect_deassert_srst
```
### Сброс и Vector table

Для правильной работы CPU после сброса необходимо прошивать в системный раздел валидную таблицу векторов.
Это справедливо в том числе и при исполнении программы из CRAM.


### Подключение без сброса

Для этого нужно запустить openocd в режиме теплого сброса. В этом случае,
перевод в отладочное состояние осуществляется без поднятия сигнала
сброса. Пример:

```shell
<openocd_root>/bin/openocd -c 'set USE_NRST 0' -f interface/cmsis-dap.cfg -f board/eliot1m.cfg
```

# Настройка GDB

GDB следует запускать со следующим скриптом инициализации:

```
file <path_to_elffile>
target ext :3333

mon reset halt

load
```

Команда `mon reset halt` будет сбрасывать отладочный модуль при каждом
подключении.

# Запись во флеш

**Внимание**: при изменении частоты SYSCLK необходимо перенастраивать тайминги
флеш-контроллера. Подробнее см. Руководство пользователя, 7.4.15 и 7.4.16.

Загрузка во флеш через GDB происходит прозрачно для программиста при
использовании обычных команд обращения в память. Пример:

```shell
(gdb) load
Loading section .data, size 0x850 lma 0x30000000
Loading section .text, size 0x26ec lma 0x10200000
Loading section .ARM.exidx, size 0x8 lma 0x102026ec
Start address 0x10200040, load size 12100
Transfer rate: 9 KB/sec, 4033 bytes/write.
```

По умолчанию openocd выполняет команду `reset init` перед очищением (erasure)
флеш и команду `reset halt` после завершения записи.  Подробнее см. openocd.pdf,
11.5.

## Проверка записи

Проверить успешность загрузки можно через выполнение команды compare-sections:
```shell
(gdb) compare-sections
Section .text, range 0x10200000 -- 0x102026ec: matched.
Section .ARM.exidx, range 0x102026ec -- 0x102026f4: matched.
Section .data, range 0x30000000 -- 0x30000850: matched.
```

Эта команда при обнаружении ошибки выводит предупреждение. Если же необходимо
прервать выполнение скрипта, то можно добавить следующее определение команды в
gdbinit-файл:

```Python
python
class CompareSectionsAndFailOnError (gdb.Command):
  """Compare section data on target to the exec file and signal an error if a difference is found.

Accepts the same arguments as a stock compare-sections command.
  """
  def __init__ (self):
    super (CompareSectionsAndFailOnError, self).__init__ ("compare-sections-and-fail-on-error", gdb.COMMAND_USER)

  def invoke (self, args, from_tty):
    try:
      compare_result = gdb.execute('compare-sections ' + args, to_string=True)
    except gdb.error as e:
      raise gdb.GdbError(e)
    if compare_result.find('MIS-MATCHED') != -1:
      raise gdb.GdbError('Verificaton failure:\n' + compare_result.rstrip())
    gdb.write(compare_result)


CompareSectionsAndFailOnError()
end
```
Используемый GDB **должен** быть собран с поддержкой питона (arm-none-eabi-gdb-py).

Пример:

```shell
(gdb) compare-sections-and-fail-on-error
Verificaton failure:
Section .text, range 0x0 -- 0x2fac: matched.
Section .ARM.exidx, range 0x2fac -- 0x2fb4: matched.
Section .data, range 0x30000000 -- 0x30000858: MIS-MATCHED!
```

## QSPI-флеш

Запись в QSPI-флеш также осуществляется через команду load при условии, что используется конфигурационный файл
платы с QSPI-флеш (board/eliot1_jc4.cfg или board/eliot1_bub.cfg).

Включить режим XIP (Execute in place) можно, выполнив следующую команду в сессии GDB:
```
mon flash_plugin enable_xip <bank_id>
```
Где <bank_id> - номер банка флеш памяти. Номер банка можно узнать с использованием команды `mon flash banks`. Например:

```
(gdb) mon flash banks
#0 : eliot1.flash.main.CPU0 (eliot1) at 0x00000000, size 0x000a0000, buswidth 0, chipwidth 0
#1 : eliot1.flash.main_ns.CPU0 (eliot1) at 0x10000000, size 0x000a0000, buswidth 0, chipwidth 0
#2 : eliot1.flash.sys.CPU0 (eliot1) at 0x10200000, size 0x00008000, buswidth 0, chipwidth 0
#3 : eliot1.flash.qspi.CPU0 (plugin) at 0x08000000, size 0x00000000, buswidth 0, chipwidth 0
```

Таким образом, номер QSPI-флеш банка - 3.

**ПРЕДУПРЕЖДЕНИЕ**: команда mon enable_xip настраивает частоты и меняет адрес вектора прерываний
с эффектом аналогичным выполнению функции BoardInitAll из eliot1-hal. Предпочтительнее настраивать режим XIP, выполняя
код из NOR-флеш памяти.

# Ошибки

## Ошибка подключения при старте openocd

```shell
Error: CMSIS-DAP command CMD_INFO failed.
```

Требуется физическое переподключение адаптера.

## Сообщения об ошибках чтения памяти в выводе openocd

```shell
Info : SWD DPIDR 0x6ba02477
 Error: Failed to read memory at 0xeffffffc
 Info : SWD DPIDR 0x6ba02477
 Error: Failed to read memory at 0xeffffffa
 Info : SWD DPIDR 0x6ba02477
 Error: Failed to read memory at 0xeffffffe
```

Cвязано с построением стека вызова GDB. Адрес `0xefffffff` содержится в
регистрах r14 (lr), r13 (sp) и r11 (fp).  Если при старте отладки установить эти
значения на читаемую память, то ошибки из вывода openocd уйдут.

## Из области флеш читаются нули, flash erase не оказывает никакого действия

Выполнить "холодный" сброс (см. секцию Сброс выше по документу).

## "IR capture error: saw 0x0f not 0x01" в выводе openocd

Что означает: к адаптеру ничего не подключено, на плату не подано питание.
Что делать: переподключить адаптер, проверить, поступает ли питание на плату.

## Ошибки в выводе openocd после сброса

Например:

```shell
...
eliot01.CPU0 – clearing lockup after double fault
target halted due to debug-request, current mode: Handler HardFault
...
```

См. раздел "Сброс и Vector table".


## Выполнение команды mass_erase для системного раздела очищает основной

Системный раздел следует очищать по секторам с использованием команды flash erase_sector.
При использовании команды GDB load никаких дополнительных действий осуществлять не надо.
