SET(TRIPLE arm-none-eabi-)
SET(CMAKE_TOOLCHAIN_SYSTEM_NAME Generic)
SET(CMAKE_TOOLCHAIN_SYSTEM_PROCESSOR arm)
SET(CMAKE_TOOLCHAIN_SYSTEM_TARGET ${TRIPLE})

# CMake determines if we are cross-compiling by looking at CMAKE_SYSTEM_NAME
# after including this file. This is done in CMakeDetermineSystem.cmake.
# If CMAKE_SYSTEM_NAME is set then it is supposed that we are cross-compiling
# and CMake sets CMAKE_CROSSCOMPILING. Otherwise it resets CMAKE_SYSTEM_* by
# host system values.
IF(NOT CMAKE_HOST_SYSTEM_PROCESSOR STREQUAL CMAKE_TOOLCHAIN_SYSTEM_PROCESSOR OR
   NOT CMAKE_HOST_SYSTEM_NAME STREQUAL CMAKE_TOOLCHAIN_SYSTEM_NAME)
    # In this case we are cross-compiling
    SET(CMAKE_SYSTEM_NAME      ${CMAKE_TOOLCHAIN_SYSTEM_NAME})
    SET(CMAKE_SYSTEM_PROCESSOR ${CMAKE_TOOLCHAIN_SYSTEM_PROCESSOR})
    SET(CMAKE_SYSTEM_TARGET    ${CMAKE_TOOLCHAIN_SYSTEM_TARGET})

    # We use only libraries in CMAKE_FIND_ROOT_PATH and don't use any binaries
    SET(CMAKE_FIND_ROOT_PATH_MODE_PROGRAM NEVER)
    SET(CMAKE_FIND_ROOT_PATH_MODE_LIBRARY ONLY)
    SET(CMAKE_FIND_ROOT_PATH_MODE_INCLUDE ONLY)
    SET(CMAKE_FIND_ROOT_PATH_MODE_PACKAGE ONLY)
ENDIF()

# If CMAKE_FIND_ROOT_PATH_MODE_* are not set find_something() behaves as is
# case when they are BOTH.

if(WIN32)
 SET(_CMAKE_TOOLCHAIN_SUFFIX ".exe")
else()
 SET(_CMAKE_TOOLCHAIN_SUFFIX "")
endif()


#GET_FILENAME_COMPONENT(MIPS_TOOLS_ROOT $ENV{MIPS_TOOLS_BINDIR} PATH)
#GET_FILENAME_COMPONENT(CMAKE_TOOLCHAIN_PREFIX ${MIPS_TOOLS_ROOT} ABSOLUTE)
#set (CMAKE_TOOLCHAIN_PREFIX ${MIPS_TOOLS_ROOT})

#SET(CMAKE_C_COMPILER    "${CMAKE_TOOLCHAIN_PREFIX}/bin/${TRIPLE}gcc${_CMAKE_TOOLCHAIN_SUFFIX}")
#SET(CMAKE_CXX_COMPILER  "${CMAKE_TOOLCHAIN_PREFIX}/bin/${TRIPLE}g++${_CMAKE_TOOLCHAIN_SUFFIX}")
#SET(CMAKE_ASM_COMPILER  "${CMAKE_TOOLCHAIN_PREFIX}/bin/${TRIPLE}as${_CMAKE_TOOLCHAIN_SUFFIX}")

SET(CMAKE_C_COMPILER    "${TRIPLE}gcc${_CMAKE_TOOLCHAIN_SUFFIX}")
SET(CMAKE_CXX_COMPILER  "${TRIPLE}g++${_CMAKE_TOOLCHAIN_SUFFIX}")
SET(CMAKE_ASM_COMPILER  "${TRIPLE}gcc${_CMAKE_TOOLCHAIN_SUFFIX}")

# Read "Modules/CMakeFindBinUtils.cmake" to see how this variables are used.
SET(_CMAKE_TOOLCHAIN_PREFIX "${CMAKE_TOOLCHAIN_SYSTEM_TARGET}")
SET(CMAKE_C_COMPILER_EXTERNAL_TOOLCHAIN "${CMAKE_TOOLCHAIN_PREFIX}")
SET(CMAKE_CXX_COMPILER_EXTERNAL_TOOLCHAIN "${CMAKE_TOOLCHAIN_PREFIX}")

LIST(APPEND CMAKE_FIND_ROOT_PATH ${CMAKE_TOOLCHAIN_PREFIX}/${CMAKE_TOOLCHAIN_SYSTEM_TARGET})

set(CMAKE_ASM_FLAGS "${CMAKE_ASM_FLAGS} -mthumb -march=armv8-m.main")
set(CMAKE_C_FLAGS   "-mthumb -march=armv8-m.main -specs=nosys.specs -Wall -Wextra -pedantic -Wstrict-prototypes")
set(CMAKE_CXX_FLAGS "${CMAKE_C_FLAGS}")
set(CMAKE_EXE_LINKER_FLAGS "${CMAKE_EXE_LINKER_FLAGS} -mthumb -march=armv8-m.main")
