#!/bin/bash
# Copyright 2018-2019 RnD Center "ELVEES", JSC

set -e
trap 'echo TEST FAILED; exit 1' ERR

ITER=${1:-2000}
SIZE=${2:-4194304}
TEST=${3:-''}
MAX_CHANNELS=${4:-1}

modprobe -q dmatestcontig iterations=$ITER test_buf_size=$SIZE wait=1 run=1 noverify=1 tests=0x01 max_channels=$MAX_CHANNELS
modprobe -rq dmatestcontig

if [[ $TEST != 'no-check' ]]; then
    SPEED=`dmesg | grep -E 'dmatestcontig.*summary' | tail -1 | cut -d : -f 3 | cut -d ' ' -f 9 | grep -Eo '[0-9]{1,7}'`

    if grep -Fq "Salute-EL24D1" /proc/device-tree/model; then
        THRESHOLD=1154048
    else
        THRESHOLD=1542144
    fi

    test $SPEED -ge $THRESHOLD
fi

echo TEST PASSED
