#!/bin/bash
# Copyright 2018-2020 RnD Center "ELVEES", JSC

set -e
trap '
    if [ $? -ne 0 ]; then
        echo TEST FAILED
    else
        echo TEST PASSED
    fi

    if [[ $(grep -E "UKF|D[12]" /proc/device-tree/model) ]]; then
        echo 0 > /sys/class/vtconsole/vtcon1/bind
        modprobe -rq vpoutfb
    fi

    rm -rf $temp
    ' EXIT

ARGS=()

while getopts "p:w:h:g:f:t:scdm:" OPT; do
    case "${OPT}" in
        m)
            MD5SUM_ORIG=${OPTARG}
        ;;
        *)
            ARGS+=(-${OPT}${OPTARG})
        ;;
    esac
done

if [ -z ${MD5SUM_ORIG} ]; then
    MD5SUM_ORIG='656c2331434fc71e95435a99fdc799fd'
fi

temp=$(mktemp -d -p /tmp $(basename "$0"XXXXXX))
cd $temp
echo Starting from $temp ..

ln -s /opt/mali/stress-test/shader.frag shader.frag
ln -s /opt/mali/stress-test/shader.vert shader.vert

if [[ $(grep -E 'UKF|D[12]' /proc/device-tree/model) ]]; then
    modprobe vpoutfb
fi

/opt/mali/stress-test/stress-test "${ARGS[@]}"

MD5SUM_DUMP=$(md5sum dump.ppm | awk '{print $1;}')

[ $MD5SUM_DUMP == $MD5SUM_ORIG ]
