#!/bin/sh -e
#
# Copyright 2015-2016 ELVEES NeoTek JSC
# Copyright 2018 RnD Center "ELVEES", JSC
# SPDX-License-Identifier: BSD-2-Clause
#
# Authors: Oleg Kitain <okitain@elvees.com>
#
# Test for MTD device:
# Format device as UBI, attach it, create large UBI volume,
# then run a verification IO suite on it.
#

trap '
    df /mnt/ubifs &> /dev/null && umount /mnt/ubifs &> /dev/null
    [ -d "/sys/devices/virtual/ubi" ] && ubidetach -p $mtddevice &> /dev/null
    ' SIGINT

print_usage() {
    echo "Usage: ubitest.sh <device> <size>"
    echo "  <device> - MTD file name"
    echo "  <size>   - Size in MiB for testing"
    echo "       (ex: ubitest.sh /dev/mtd0 800)"
}

mtddevice=$1
testsize=$2

if [ $# != 2 ]; then
    print_usage
    exit 0
fi

if [ ! -c "$mtddevice" ]; then
    print_usage
    echo "Device ${mtddevice} does not exist"
    exit 1
fi

if ! [ "$testsize" -gt "0" ] 2> /dev/null; then
    print_usage
    echo "Size must be an integer greater than 0"
    exit 1
fi

echo 1..3
ubiformat -y $mtddevice &> /dev/null
ubiattach -p $mtddevice &> /dev/null
ubimkvol /dev/ubi0 -m -N full_ubi &> /dev/null
mkdir -p /mnt/ubifs
mount -t ubifs /dev/ubi0_0 /mnt/ubifs

echo ok 1 - Create and mount UBIFS partition

fio --name=verify --rw=randwrite --bs=4MiB --verify=md5 --aux-path=/tmp \
    --verify_fatal=1 --directory=/mnt/ubifs --size=${testsize}MiB &>/dev/null

echo ok 2 - Write and verify with fio

umount /mnt/ubifs
ubidetach -p $mtddevice
ubiattach -p $mtddevice &> /dev/null
mount -t ubifs /dev/ubi0_0 /mnt/ubifs
rm /mnt/ubifs/* -rf
umount /mnt/ubifs
rmdir /mnt/ubifs
ubidetach -p $mtddevice

echo ok 3 - Test master node corruption after remount
echo TEST PASSED
