#!/bin/sh -e
#
# Copyright 2016 RnD Center "ELVEES", JSC
# SPDX-License-Identifier: BSD-2-Clause
#
# Author: Oleg Kitain <okitain@elvees.com>
#
# This is a functional test for the VPOUT framebuffer driver
# The test requires someone to check the image on the screen
# with each new resolution.
# Outputs TAP stream to stdout.
#

tapcount=1
globexcode=0
# $1 is exit code, $2 is string
tapfin() {
    if [ $1 -ne 0 ]; then
        echo "not ok $tapcount - $2"
        globexcode=1
    else
        echo "ok $tapcount - $2"
    fi
    tapcount=$(($tapcount + 1))
}

DURATION=5
SIZE=640x480

arr="640x480@60 1280x720@60 1920x1080@60"

maxcnt=0
for i in $arr; do
    maxcnt=$(($maxcnt + 1))
done
echo "1..$((maxcnt*2))"

ffmpeg -loglevel error -y -f lavfi \
        -i testsrc=duration=$DURATION:size=$SIZE \
        -pix_fmt yuv420p tester.y4m

for i in $arr; do
    fbset $i >/dev/null
    tapfin $? "Resolution changed to $i"
    sleep 5
    ffmpeg -re -i tester.y4m -f fbdev -pix_fmt bgra /dev/fb0 &>/dev/null
    tapfin $? "Playing video on resolution $i"
done
rm -f tester.y4m tmpfile
exit $globexcode
