#!/bin/sh
#
# Copyright 2018 RnD Center "ELVEES", JSC
#
# This script setup Ethernet PHY (DP83867 chip) on UKF-1892VM14YA board to loopback mode at speed 100 Mb/s.
#

set -o errexit

MDIOCTL=0x3800f1a0
MDIODATA=0x3800f1a4

_read_reg() {
    local ADDR=$1
    local CTL=$((ADDR << 5 | 0x8400))
    devmem $MDIOCTL 32 $CTL
    usleep 10000
    devmem $MDIODATA
}

_write_reg() {
    local ADDR=$1
    local VALUE=$2
    devmem $MDIODATA 32 $VALUE
    local CTL=$((ADDR << 5 | 0x8000))
    devmem $MDIOCTL 32 $CTL
    usleep 10000
}

_read_ext_reg() {
    local ADDR=$1
    _write_reg 0xd 0x1f
    _write_reg 0xe $ADDR
    _write_reg 0xd 0x401f
    _read_reg 0xe
}

_write_ext_reg() {
    local ADDR=$1
    local VALUE=$2
    _write_reg 0xd 0x1f
    _write_reg 0xe $ADDR
    _write_reg 0xd 0x401f
    _write_reg 0xe $VALUE
}

phy_read() {
    local ADDR=`printf "%d" $1`

    if [ $ADDR -gt 31 ]; then
        _read_ext_reg $ADDR
    else
        _read_reg $ADDR
    fi
}

phy_write() {
    local ADDR=`printf "%d" $1`
    local VALUE=`printf "%d" $2`

    if [ $ADDR -gt 31 ]; then
        _write_ext_reg $ADDR $VALUE
    else
        _write_reg $ADDR $VALUE
    fi
}

MODEL=$(cat /proc/device-tree/model)
if [ "$MODEL" != "TFK r0" ]; then
    echo "This script can be used only with TFK board"
    exit 1
fi

# Disable RGMII
VAL=$(phy_read 0x32)
VAL=$((VAL & ~0x80))
phy_write 0x32 $VAL

# Force 100Mbs good link
VAL=$(phy_read 0x43)
VAL=$((VAL | 0x40))
phy_write 0x43 $VAL

ethtool -s eth0 autoneg off
ethtool -s eth0 duplex full
ethtool -s eth0 speed 100
sleep 1

# Enable loopback. This must be last action because ethtool resets loopback bit.
VAL=$(phy_read 0)
VAL=$((VAL | 0x4000))
phy_write 0 $VAL
