#!/usr/bin/env bash
#
# Copyright 2024 RnD Center "ELVEES", JSC
#
# SPDX-License-Identifier: GPLv2

alsa_dir="/var/lib/alsa/"
asound_state="/var/lib/alsa/asound.state"
if test -f ${asound_state}; then
	echo "File ${asound_state} exists, exiting..."
	exit
fi

kernel_version=$(uname -r | cut -d '.' -f 1,2)
# We want to detele the possible null byte from the warning shown below using tr instead of cat:
# warning: command substitution: ignored null byte in input
board_model=$(tr -d '\0' < /sys/firmware/devicetree/base/model)

# Get asound.state for pair PM-CB
board_asound_state="/etc/elvees-alsa-prepare/linux$kernel_version/${board_model}/asound.state"

# If no asound.state for pair PM-CB, get asound.state for CB
if ! test -f "$board_asound_state"; then
	cb_model=$(echo "$board_model" | cut -d ',' -f 2 | cut -c2-)
	board_asound_state="/etc/elvees-alsa-prepare/linux$kernel_version/${cb_model}/asound.state"
fi

# If no asound.state for CB, get asound.state for PM
if ! test -f "$board_asound_state"; then
	pm_model=$(echo "$board_model" | cut -d ',' -f 1)
	board_asound_state="/etc/elvees-alsa-prepare/linux$kernel_version/${pm_model}/asound.state"
fi

if ! test -f "$board_asound_state"; then
	echo "Either board ${board_model} doesn't require asound.state or elvees-alsa-prepare is required to be updated to support this board."
	exit
fi

if ! test -d "$alsa_dir"; then
	mkdir "$alsa_dir"
fi

ln -s "$board_asound_state" "$asound_state"
if ! [ $? ]; then
	echo "Can't create ${asound_state} symlink"
fi
