#!/usr/bin/env bash
#
# Copyright 2022 RnD Center "ELVEES", JSC
#
# This script runs videostream from sensor to display on MCom-03 platform supporting CSI & HDMI.
# The script is configured to run with Arducam 5MP OV5647 camera board.

ISPC_LOOP_ARGS="-sensor OV5647_0 -setupFile ov5647-arducam.cfg -chooseAWB 1 -importBuffers -nBuffers 2"

error() {
    echo "Error: $1"
    exit 1
}

ISP_ETC_DIR=/etc/felix/ov5647
cd $ISP_ETC_DIR || error "$ISP_ETC_DIR does not exist!"
felix-ispc-loop $ISPC_LOOP_ARGS > /dev/null
