// Copyright 2020 RnD Center "ELVEES", JSC

#ifndef _SYSCALL_RUNTIME_H_
#define _SYSCALL_RUNTIME_H_

#include <stdint.h>

typedef struct __attribute__((packed)) {
    uint64_t sec;
    uint64_t usec;
} timeval_compat;

typedef struct __attribute__((packed)) {
    int16_t    stat_compat_dev;
    uint16_t   stat_compat_ino;
    uint32_t   stat_compat_mode;
    uint16_t   stat_compat_nlink;
    uint16_t   stat_compat_uid;
    uint16_t   stat_compat_gid;
    int16_t    stat_compat_rdev;
    int32_t    stat_compat_size;
    int32_t    stat_compat_atime;
    int32_t    stat_compat_spare1;
    int32_t    stat_compat_mtime;
    int32_t    stat_compat_spare2;
    int32_t    stat_compat_ctime;
    int32_t    stat_compat_spare3;
    int32_t    stat_compat_blksize;
    int32_t    stat_compat_blocks;

    int32_t stat_compat_spare4[2];
} stat_compat;

typedef struct __attribute__((packed)) {
    uint64_t tms_utime;
    uint64_t tms_stime;
    uint64_t tms_cutime;
    uint64_t tms_cstime;
} tms_compat;

#endif
