// Copyright 2025 RnD Center "ELVEES", JSC

#include "tests_tile_segmentation.hpp"

template <typename Ret_Type, typename Type, class create_func, class ref_func, class run_calc_ptr>
bool test_dotprod(Type* src0, Type* src1, create_func create_vector, ref_func reference, run_calc_ptr run_calc,
                  int size, int* localmem) {
  create_vector(src0, size, -10, 10);
  create_vector(src1, size, -10, 10);

  FLUSH_ALL_CACHES();
  uint32_t tic_count[2], instruction_count[2];
  count_tics(tic_count, instruction_count);
  Ret_Type ref_result = reference(src0, src1, size);
  count_tics(&tic_count[1], &instruction_count[1]);

  std::cout << "Ref func result (size = " << size << "): tic = " << tic_count[1] - tic_count[0]
            << " instr = " << instruction_count[1] - instruction_count[0] << std::endl;

  TileSegConfig config;
  CreateTileSegConfigDotprod(src0, src1, size, &config, (uint16_t*)localmem);

  FLUSH_ALL_CACHES();

  count_tics(tic_count, instruction_count);
  Ret_Type opt_result = run_calc(&config);
  count_tics(&tic_count[1], &instruction_count[1]);

  std::cout << "Opt func result (size = " << size << "): tic = " << tic_count[1] - tic_count[0]
            << " instr = " << instruction_count[1] - instruction_count[0] << std::endl;

  int ret = (ref_result != opt_result);
  return ret;
}

int main() {
  disable_l2_cache();

  void* src0 = memalign(64, SIZE * sizeof(int64_t));
  void* src1 = memalign(64, SIZE * sizeof(int64_t));

  int ret = 0;
  int test_status = 0;

  for (int i = 1; i <= SIZE; i *= 2) {
    std::cout << "dotprod_s16" << std::endl;
#ifdef USE_REF_VER
    ret = test_dotprod<int32_t>(static_cast<int16_t*>(src0), static_cast<int16_t*>(src1), data_generator<int16_t>,
                                ref_dotprod, RunCalculationDotprod16, i, &__local_mem);
#else
    ret = test_dotprod<int32_t>(static_cast<int16_t*>(src0), static_cast<int16_t*>(src1), data_generator<int16_t>,
                                dotprod, RunCalculationDotprod16, i, &__local_mem);
#endif

    test_status |= ret;
    if (ret) std::cout << "dotprod16 error!\n";

    std::cout << "dotprod_s32" << std::endl;
#ifdef USE_REF_VER
    ret = test_dotprod<int64_t>(static_cast<int32_t*>(src0), static_cast<int32_t*>(src1), data_generator<int32_t>,
                                ref_dotprod32, RunCalculationDotprod32, i, &__local_mem);
#else
    ret = test_dotprod<int64_t>(static_cast<int32_t*>(src0), static_cast<int32_t*>(src1), data_generator<int32_t>,
                                dotprod32, RunCalculationDotprod32, i, &__local_mem);
#endif

    test_status |= ret;
    if (ret) std::cout << "dotprod32 error!\n";

    std::cout << "dotprod_fl" << std::endl;
#ifdef USE_REF_VER
    ret = test_dotprod<float>(static_cast<float*>(src0), static_cast<float*>(src1), data_generator<float>,
                              ref_dotprod_fl, RunCalculationDotprodFl, i, &__local_mem);
#else
    ret = test_dotprod<float>(static_cast<float*>(src0), static_cast<float*>(src1), data_generator<float>, dotprod_fl,
                              RunCalculationDotprodFl, i, &__local_mem);
#endif

    test_status |= ret;
    if (ret) std::cout << "dotprod_fl error!\n";

    std::cout << "dotprod_db" << std::endl;
#ifdef USE_REF_VER
    ret = test_dotprod<double>(static_cast<double*>(src0), static_cast<double*>(src1), data_generator<double>,
                               ref_dotprod_db, RunCalculationDotprodDb, i, &__local_mem);
#else
    ret = test_dotprod<double>(static_cast<double*>(src0), static_cast<double*>(src1), data_generator<double>,
                               dotprod_db, RunCalculationDotprodDb, i, &__local_mem);
#endif

    test_status |= ret;
    if (ret) std::cout << "dotprod_db error!\n";

    if (!test_status)
      std::cout << "Test passed" << std::endl;
    else
      std::cout << "Test failed" << std::endl;
  }

  free(src0);
  free(src1);

  enable_l2_cache(L2_CACHE_SIZE);

  return test_status;
}
