// Copyright 2025 RnD Center "ELVEES", JSC

/*! \file
 *  \brief Заголовочный файл с функциями для преобразования типов
 */

#ifndef TYPES_CONVERTER_H
#define TYPES_CONVERTER_H

#include "elcore50-signal-lib/elcore50.h"

/// Преобразование вектора типа float16 в float
extern void float16_to_float32(int16* src,  ///< [in] входные данные
                               float* dst,  ///< [out] выходные данные
                               int size     ///< [in] размер массива
);
/// Преобразование вектора типа float в float16
extern void float32_to_float16(float* src,  ///< [in] входные данные
                               int16* dst,  ///< [out] выходные данные
                               int size     ///< [in] размер массива
);
/// Преобразование вектора типа float в fractional16
void float32_to_fract16(float* src,     ///< [in] входные данные
                        int16* dst,     ///< [out] выходные данные
                        const int size  ///< [in] размер входных данных
);
/// Преобразование вектора типа fractional16 в float
void fract16_to_float32(int16* src,     ///< [in] входные данные
                        float* dst,     ///< [out] dst выходные данные
                        const int size  ///< [in] size размер входных данных
);

#endif
