# Примеры использования elcore50-signal-lib

В примерах для входного сигнала вычисляется обратное Быстрое Преобразование Фурье (БПФ).
Затем к полученному решению применяется прямое БПФ. Пример печатает `passed`, если результат
прямого БПФ совпал со входным сигналом, в противном случае - `failed`.

# Список примеров

* [sample-fft-float16-1d](sample-fft-float16-1d) - одномерное обратное и прямое БПФ
для типа float16 (hfloat);
* [sample-fft-fract16-2d](sample-fft-fract16-2d) - двумерное обратное и прямое БПФ
для типа fractional16;
* [sample-fft-all](sample-fft-all) - примеры использования библиотеки для всех типов
данных и размерностей.

# Сборка

Для сборки примеров понадобится aarch64-buildroot-linux-gnu_sdk-buildroot из
[MCom-03 Linux SDK](https://dist.elvees.com/mcom03/docs/linux-sdk/latest/components/buildroot.html#toolchain).

Команды для сборки:
```bash
mkdir build && cd build

cmake \
    -DCMAKE_TOOLCHAIN_FILE=<путь/до/aarch64-buildroot-linux-gnu/opt/toolchain-elcore50/share/cmake/elcore50_toolchain.cmake> \
    -DElcoreRuntime_DIR=<путь/до/aarch64-buildroot-linux-gnu/sysroot/usr/lib/cmake/ElcoreRuntime> \
    -Delcore50-signal-lib_DIR=<путь/до/aarch64-buildroot-linux-gnu/sysroot/usr/share/elcore50/libraries/lib/cmake/elcore50-signal-lib> \
    ..
```

# Запуск примеров

Для запуска используется утилита
[elcorecl-run](https://dist.elvees.com/elcorecl/docs/latest/components/elcorecl-run.html).

## sample-fft-float16-1d

```bash
elcorecl-run -e sample-fft-float16-1d
```

Пример вывода:
```bash
float16 1d sample result:
fft_size = 262144, passed!
```

Размер преобразования и тип памяти определяются внутри программы.

## sample-fft-fract16-2d

```bash
elcorecl-run -e sample-fft-fract16-2d
```

Пример вывода:
```bash
fract16 2d sample result:
rows = 512, cols = 512, passed!
```

Размер преобразования и тип памяти определяются внутри программы.

## sample-fft-all

```bash
elcorecl-run -e sample-fft-all -- 2d float32 -r 64 -c 512 -m 0
```

Для просмотра всех опций:
```bash
elcorecl-run -e sample-fft-all -- -h
```

Пример вывода:
```bash
float32 2d sample result:
rows = 64, cols = 512, mem_type = SL_DDR: passed!
```
