// Copyright 2018-2025 RnD Center "ELVEES", JSC

/*! \file
 *  \brief Заголовочный файл c функциями тестирования библиотеки
 *  \author Фролов Андрей
 */

#include <elcore50-dsplib/asm_func.h>
#include <elcore50-dsplib/elcore50.h>
#include <elcore50-dsplib/reference.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>

#include "helper.h"

extern int __local_mem;
#define LOCAL_MEM
//! количество тестов для каждой их функций. Максимальное количество равно пяти
#define TEST_COUNT 5
//! верхняя граница полного перебора размеров данных для long тестов
#define LONG_TESTS_VALUE 32

#define DISABLE_NEG_TEST_DATA
#define DISABLE_POS_TEST_DATA

/*!
 *  \fn int test_maxval(int16_t* src0, int size, int print)
 *  \brief Тестирование функции поиска значения максимального элемента массива maxval для типа int16
 *  \param[in] src0 входные данные типа int16
 *  \param[in] size размер входных массивов
 *  \param[in] print флаг для печати данных
 *  \param[in] input_bytes размер входных массивов в байтах
 *  \param[in] ti_tics информация о тиках TI
 *  \return
 *      - \b int количество ошибок
 */
int test_maxval(int16_t* src0, int size, int print, int32_t input_bytes, int32_t ti_tics);
/*!
 *  \fn int test_maxval32(int32_t* src0, int size, int print)
 *  \brief Тестирование функции поиска значения максимального элемента вектора maxval для типа int32
 *  \param[in] src0 входные данные типа int32
 *  \param[in] size размер входных массивов
 *  \param[in] print флаг для печати данных
 *  \param[in] input_bytes размер входных массивов в байтах
 *  \param[in] ti_tics информация о тиках TI
 *  \return
 *      - \b int количество ошибок
 */
int test_maxval32(int32_t* src0, int size, int print, int32_t input_bytes, int32_t ti_tics);
/*!
 *  \fn int test_maxval_fl(float* src0, int size, int print)
 *  \brief Тестирование функции поиска значения максимального элемента вектора maxval для типа float
 *  \param[in] src0 входные данные типа float
 *  \param[in] size размер входных массивов
 *  \param[in] print флаг для печати данных
 *  \param[in] input_bytes размер входных массивов в байтах
 *  \param[in] ti_tics информация о тиках TI
 *  \return
 *      - \b int количество ошибок
 */
int test_maxval_fl(float* src0, int size, int print, int32_t input_bytes, int32_t ti_tics);
/*!
 *  \fn int test_maxval_db(double* src0, int size, int print)
 *  \brief Тестирование функции поиска значения максимального элемента вектора массива Maxval для типа double
 *  \param[in] src0 входные данные типа double
 *  \param[in] size размер входных массивов
 *  \param[in] print флаг для печати данных
 *  \param[in] input_bytes размер входных массивов в байтах
 *  \param[in] ti_tics информация о тиках TI
 *  \return
 *      - \b int количество ошибок
 */
int test_maxval_db(double* src0, int size, int print, int32_t input_bytes, int32_t ti_tics);

/*!
 *  \fn int test_adds16(int16_t* src0, int16_t* src1, int16_t* dst_ref, int16_t* dst_opt, int size, int print)
 *  \brief Тестирование функции add для типа int16
 *  \param[in] src0 входные данные типа int16
 *  \param[in] src1 входные данные типа int16
 *  \param[out] dst_ref выходные данные типа int16 референсной функции
 *  \param[out] dst_opt выходные данные типа int16 ассемблерной функции
 *  \param[in] size размер входных массивов
 *  \param[in] print флаг для печати данных
 *  \param[in] input_bytes размер входных массивов в байтах
 *  \param[in] ti_tics информация о тиках TI
 *  \return
 *      - \b int количество ошибок
 */
int test_adds16(int16_t* src0, int16_t* src1, int16_t* dst_ref, int16_t* dst_opt, int size, int print,
                int32_t input_bytes, int32_t ti_tics);
/*!
 *  \fn int test_adds32(int32_t* src0, int32_t* src1, int32_t* dst_ref, int32_t* dst_opt, int size, int print)
 *  \brief Тестирование функции add для типа int32
 *  \param[in] src0 входные данные типа int32
 *  \param[in] src1 входные данные типа int32
 *  \param[out] dst_ref выходные данные типа int32 референсной функции
 *  \param[out] dst_opt выходные данные типа int32 ассемблерной функции
 *  \param[in] size размер входных массивов
 *  \param[in] print флаг для печати данных
 *  \param[in] input_bytes размер входных массивов в байтах
 *  \param[in] ti_tics информация о тиках TI
 *  \return
 *      - \b int количество ошибок
 */
int test_adds32(int32_t* src0, int32_t* src1, int32_t* dst_ref, int32_t* dst_opt, int size, int print,
                int32_t input_bytes, int32_t ti_tics);
/*!
 *  \fn int test_add_fl(float* src0, float* src1, float* dst_ref, float* dst_opt, int size, int print)
 *  \brief Тестирование функции add для типа float
 *  \param[in] src0 входные данные типа float
 *  \param[in] src1 входные данные типа float
 *  \param[out] dst_ref выходные данные типа float референсной функции
 *  \param[out] dst_opt выходные данные типа float ассемблерной функции
 *  \param[in] size размер входных массивов
 *  \param[in] print флаг для печати данных
 *  \param[in] input_bytes размер входных массивов в байтах
 *  \param[in] ti_tics информация о тиках TI
 *  \return
 *      - \b int количество ошибок
 */
int test_add_fl(float* src0, float* src1, float* dst_ref, float* dst_opt, int size, int print, int32_t input_bytes,
                int32_t ti_tics);
/*!
 *  \fn int test_add_db(double* src0, double* src1, double* dst_ref, double* dst_opt, int size, int print)
 *  \brief Тестирование функции add для типа double
 *  \param[in] src0 входные данные типа double
 *  \param[in] src1 входные данные типа double
 *  \param[out] dst_ref выходные данные типа double референсной функции
 *  \param[out] dst_opt выходные данные типа double ассемблерной функции
 *  \param[in] size размер входных массивов
 *  \param[in] print флаг для печати данных
 *  \param[in] input_bytes размер входных массивов в байтах
 *  \param[in] ti_tics информация о тиках TI
 *  \return
 *      - \b int количество ошибок
 */
int test_add_db(double* src0, double* src1, double* dst_ref, double* dst_opt, int size, int print, int32_t input_bytes,
                int32_t ti_tics);

/*!
 *  \fn int test_minval(int16_t* src0, int size, int print)
 *  \brief Тестирование функции поиска значения минимального элемента массива minval для типа int16
 *  \param[in] src0 входные данные типа int16
 *  \param[in] size размер входных массивов
 *  \param[in] print флаг для печати данных
 *  \param[in] input_bytes размер входных массивов в байтах
 *  \param[in] ti_tics информация о тиках TI
 *  \return
 *      - \b int количество ошибок
 */
int test_minval(int16_t* src0, int size, int print, int32_t input_bytes, int32_t ti_tics);
/*!
 *  \fn int test_minval32(int32_t* src0, int size, int print)
 *  \brief Тестирование функции поиска значения минимального элемента массива minval для типа int32
 *  \param[in] src0 входные данные типа int32
 *  \param[in] size размер входных массивов
 *  \param[in] print флаг для печати данных
 *  \param[in] input_bytes размер входных массивов в байтах
 *  \param[in] ti_tics информация о тиках TI
 *  \return
 *      - \b int количество ошибок
 */
int test_minval32(int32_t* src0, int size, int print, int32_t input_bytes, int32_t ti_tics);
/*!
 *  \fn int test_minval_fl(float* src0, int size, int print)
 *  \brief Тестирование функции поиска значения минимального элемента массива minval для типа float
 *  \param[in] src0 входные данные типа float
 *  \param[in] size размер входных массивов
 *  \param[in] print флаг для печати данных
 *  \param[in] input_bytes размер входных массивов в байтах
 *  \param[in] ti_tics информация о тиках TI
 *  \return
 *      - \b int количество ошибок
 */
int test_minval_fl(float* src0, int size, int print, int32_t input_bytes, int32_t ti_tics);
/*!
 *  \fn int test_minval_db(double* src0, int size, int print)
 *  \brief Тестирование функции поиска значения минимального элемента массива minval для типа double
 *  \param[in] src0 входные данные типа double
 *  \param[in] size размер входных массивов
 *  \param[in] print флаг для печати данных
 *  \param[in] input_bytes размер входных массивов в байтах
 *  \param[in] ti_tics информация о тиках TI
 *  \return
 *      - \b int количество ошибок
 */
int test_minval_db(double* src0, int size, int print, int32_t input_bytes, int32_t ti_tics);

/*!
 *  \fn int test_dotp_sqr(int16_t* src0, int16_t* src1, int size, int32_t G, int print)
 *  \brief Тестирование функции dotp_sqr для типа int16
 *  \param[in] src0 входные данные типа int16
 *  \param[in] src1 входные данные типа int16
 *  \param[in] size размер входных массивов
 *  \param[in] G коэффициент для подсчета суммы квадратов массива
 *  \param[in] print флаг для печати данных
 *  \param[in] input_bytes размер входных массивов в байтах
 *  \param[in] ti_tics информация о тиках TI
 *  \return
 *      - \b int количество ошибок
 */
int test_dotp_sqr(int16_t* src0, int16_t* src1, int size, int32_t G, int print, int32_t input_bytes, int32_t ti_tics);
/*!
 *  \fn int test_dotp_sqr32(int32_t* src0, int32_t* src1, int size, int64_t G, int print)
 *  \brief Тестирование функции dotp_sqr для типа int32
 *  \param[in] src0 входные данные типа int32
 *  \param[in] src1 входные данные типа int32
 *  \param[in] size размер входных массивов
 *  \param[in] G коэффициент для подсчета суммы квадратов массива
 *  \param[in] print флаг для печати данных
 *  \param[in] input_bytes размер входных массивов в байтах
 *  \param[in] ti_tics информация о тиках TI
 *  \return
 *      - \b int количество ошибок
 */
int test_dotp_sqr32(int32_t* src0, int32_t* src1, int size, int64_t G, int print, int32_t input_bytes,
                    int32_t ti_tics);
/*!
 *  \fn int test_dotp_sqr_fl(float* src0, float* src1, int size, float G, int print)
 *  \brief Тестирование функции dotp_sqr для типа float
 *  \param[in] src0 входные данные типа float
 *  \param[in] src1 входные данные типа float
 *  \param[in] size размер входных массивов
 *  \param[in] G коэффициент для подсчета суммы квадратов массива
 *  \param[in] print флаг для печати данных
 *  \param[in] input_bytes размер входных массивов в байтах
 *  \param[in] ti_tics информация о тиках TI
 *  \return
 *      - \b int количество ошибок
 */
int test_dotp_sqr_fl(float* src0, float* src1, int size, float G, int print, int32_t input_bytes, int32_t ti_tics);
/*!
 *  \fn int test_dotp_sqr_db(double* src0, double* src1, int size, double G, int print)
 *  \brief Тестирование функции dotp_sqr для типа int16
 *  \param[in] src0 входные данные типа int16
 *  \param[in] src1 входные данные типа int16
 *  \param[in] size размер входных массивов
 *  \param[in] G коэффициент для подсчета суммы квадратов массива
 *  \param[in] print флаг для печати данных
 *  \param[in] input_bytes размер входных массивов в байтах
 *  \param[in] ti_tics информация о тиках TI
 *  \return
 *      - \b int количество ошибок
 */
int test_dotp_sqr_db(double* src0, double* src1, int size, double G, int print, int32_t input_bytes, int32_t ti_tics);

/*!
 *  \fn int test_dotprod(int16_t* src0, int16_t* src1, int size, int print)
 *  \brief Тестирование функции dotprod для типа int16
 *  \param[in] src0 входные данные типа int16
 *  \param[in] src1 входные данные типа int16
 *  \param[in] size размер входных массивов
 *  \param[in] print флаг для печати данных
 *  \param[in] input_bytes размер входных массивов в байтах
 *  \param[in] ti_tics информация о тиках TI
 *  \return
 *      - \b int количество ошибок
 */
int test_dotprod(int16_t* src0, int16_t* src1, int size, int print, int32_t input_bytes, int32_t ti_tics);
/*!
 *  \fn int test_dotprod32(int32_t* src0, int32_t* src1, int size, int print)
 *  \brief Тестирование функции dotprod для типа int32
 *  \param[in] src0 входные данные типа int32
 *  \param[in] src1 входные данные типа int32
 *  \param[in] size размер входных массивов
 *  \param[in] print флаг для печати данных
 *  \param[in] input_bytes размер входных массивов в байтах
 *  \param[in] ti_tics информация о тиках TI
 *  \return
 *      - \b int количество ошибок
 */
int test_dotprod32(int32_t* src0, int32_t* src1, int size, int print, int32_t input_bytes, int32_t ti_tics);
/*!
 *  \fn int test_dotprod_fl(float* src0, float* src1, int size, int print)
 *  \brief Тестирование функции dotprod для типа float
 *  \param[in] src0 входные данные типа float
 *  \param[in] src1 входные данные типа float
 *  \param[in] size размер входных массивов
 *  \param[in] print флаг для печати данных
 *  \param[in] input_bytes размер входных массивов в байтах
 *  \param[in] ti_tics информация о тиках TI
 *  \return
 *      - \b int количество ошибок
 */
int test_dotprod_fl(float* src0, float* src1, int size, int print, int32_t input_bytes, int32_t ti_tics);
/*!
 *  \fn int test_dotprod_db(double* src0, double* src1, int size, int print)
 *  \brief Тестирование функции dotprod для типа double
 *  \param[in] src0 входные данные типа double
 *  \param[in] src1 входные данные типа double
 *  \param[in] size размер входных массивов
 *  \param[in] print флаг для печати данных
 *  \param[in] input_bytes размер входных массивов в байтах
 *  \param[in] ti_tics информация о тиках TI
 *  \return
 *      - \b int количество ошибок
 */
int test_dotprod_db(double* src0, double* src1, int size, int print, int32_t input_bytes, int32_t ti_tics);

/*!
 *  \fn int test_mat_mul(int16_t* src0, int16_t* src1, int16_t* dst_ref, int16_t* dst_opt, int rows0, int columns0, int
 * columns1, int print, int32_t shift)
 *  \brief Тестирование функции умножения матриц mat_mul для типа int16
 *  \param[in] src0 входные данные типа int16
 *  \param[in] src1 входные данные типа int16
 *  \param[out] dst_ref выходные данные типа int16 референсной функции
 *  \param[out] dst_opt выходные данные типа int16 ассемблерной функции
 *  \param[in] rows0 количество строк первой матрицы
 *  \param[in] columns0 количество столбцов первой матрицы
 *  \param[in] columns1 количество столбцов второй матрицы
 *  \param[in] print флаг для печати данных
 *  \param[in] shift сдвиг результата
 *  \param[in] input_bytes размер входных массивов в байтах
 *  \param[in] ti_tics информация о тиках TI
 *  \return
 *      - \b int количество ошибок
 */
int test_mat_mul(int16_t* src0, int16_t* src1, int16_t* dst_ref, int16_t* dst_opt, int rows0, int columns0,
                 int columns1, int print, int32_t shift, int32_t input_bytes, int32_t ti_tics);
/*!
 *  \fn int test_mat_mul32(int32_t* src0, int32_t* src1, int32_t* dst_ref, int32_t* dst_opt, int rows0, int columns0,
 * int columns1, int print, int32_t shift)
 *  \brief Тестирование функции умножения матриц mat_mul для типа int32
 *  \param[in] src0 входные данные типа int32
 *  \param[in] src1 входные данные типа int32
 *  \param[out] dst_ref выходные данные типа int32 референсной функции
 *  \param[out] dst_opt выходные данные типа int32 ассемблерной функции
 *  \param[in] rows0 количество строк первой матрицы
 *  \param[in] columns0 количество столбцов первой матрицы
 *  \param[in] columns1 количество столбцов второй матрицы
 *  \param[in] print флаг для печати данных
 *  \param[in] shift сдвиг результата
 *  \param[in] input_bytes размер входных массивов в байтах
 *  \param[in] ti_tics информация о тиках TI
 *  \return
 *      - \b int количество ошибок
 */
int test_mat_mul32(int32_t* src0, int32_t* src1, int32_t* dst_ref, int32_t* dst_opt, int rows0, int columns0,
                   int columns1, int print, int32_t shift, int32_t input_bytes, int32_t ti_tics);
/*!
 *  \fn int test_mat_mul_fl(float* src0, float* src1, float* dst_ref, float* dst_opt, int rows0, int columns0, int
 * columns1, int print, int32_t shift)
 *  \brief Тестирование функции умножения матриц mat_mul для типа float
 *  \param[in] src0 входные данные типа float
 *  \param[in] src1 входные данные типа float
 *  \param[out] dst_ref выходные данные типа float референсной функции
 *  \param[out] dst_opt выходные данные типа float ассемблерной функции
 *  \param[in] rows0 количество строк первой матрицы
 *  \param[in] columns0 количество столбцов первой матрицы
 *  \param[in] columns1 количество столбцов второй матрицы
 *  \param[in] print флаг для печати данных
 *  \param[in] shift сдвиг результата
 *  \param[in] input_bytes размер входных массивов в байтах
 *  \param[in] ti_tics информация о тиках TI
 *  \return
 *      - \b int количество ошибок
 */
int test_mat_mul_fl(float* src0, float* src1, float* dst_ref, float* dst_opt, int rows0, int columns0, int columns1,
                    int print, int32_t shift, int32_t input_bytes, int32_t ti_tics);
/*!
 *  \fn int test_mat_mul_db(double* src0, double* src1, double* dst_ref, double* dst_opt, int rows0, int columns0, int
 * columns1, int print, int32_t shift)
 *  \brief Тестирование функции умножения матриц mat_mul для типа double
 *  \param[in] src0 входные данные типа double
 *  \param[in] src1 входные данные типа double
 *  \param[out] dst_ref выходные данные типа double референсной функции
 *  \param[out] dst_opt выходные данные типа double ассемблерной функции
 *  \param[in] rows0 количество строк первой матрицы
 *  \param[in] columns0 количество столбцов первой матрицы
 *  \param[in] columns1 количество столбцов второй матрицы
 *  \param[in] print флаг для печати данных
 *  \param[in] shift сдвиг результата
 *  \param[in] input_bytes размер входных массивов в байтах
 *  \param[in] ti_tics информация о тиках TI
 *  \return
 *      - \b int количество ошибок
 */
int test_mat_mul_db(double* src0, double* src1, double* dst_ref, double* dst_opt, int rows0, int columns0,
                    int columns1, int print, int32_t shift, int32_t input_bytes, int32_t ti_tics);

/*!
 *  \fn int test_mat_mul_cplx(int16_t* src0, int16_t* src1, int16_t* dst_ref, int16_t* dst_opt, int rows0, int
 * columns0, int columns1, int print, int32_t shift)
 *  \brief Тестирование функции комплексного умножения матриц mat_mul_cplx для типа int16 (cint16)
 *  \param[in] src0 входные данные типа int16 (cint16)
 *  \param[in] src1 входные данные типа int16 (cint16)
 *  \param[out] dst_ref выходные данные типа int16 (cint16) референсной функции
 *  \param[out] dst_opt выходные данные типа int16 (cint16) ассемблерной функции
 *  \param[in] rows0 количество строк первой матрицы
 *  \param[in] columns0 количество столбцов первой матрицы
 *  \param[in] columns1 количество столбцов второй матрицы
 *  \param[in] print флаг для печати данных
 *  \param[in] shift сдвиг результата
 *  \param[in] input_bytes размер входных массивов в байтах
 *  \param[in] ti_tics информация о тиках TI
 *  \return
 *      - \b int количество ошибок
 */
int test_mat_mul_cplx(int16_t* src0, int16_t* src1, int16_t* dst_ref, int16_t* dst_opt, int rows0, int columns0,
                      int columns1, int print, int32_t shift, int32_t input_bytes, int32_t ti_tics);
/*!
 *  \fn int test_mat_mul_cplx32(int32_t* src0, int32_t* src1, int32_t* dst_ref, int32_t* dst_opt, int rows0, int
 * columns0, int columns1, int print, int32_t shift)
 *  \brief Тестирование функции комплексного умножения матриц mat_mul_cplx для типа int32 (cint32)
 *  \param[in] src0 входные данные типа int32 (cint32)
 *  \param[in] src1 входные данные типа int32 (cint32)
 *  \param[out] dst_ref выходные данные типа int32 (cint32) референсной функции
 *  \param[out] dst_opt выходные данные типа int32 (cint32) ассемблерной функции
 *  \param[in] rows0 количество строк первой матрицы
 *  \param[in] columns0 количество столбцов первой матрицы
 *  \param[in] columns1 количество столбцов второй матрицы
 *  \param[in] print флаг для печати данных
 *  \param[in] shift сдвиг результата
 *  \param[in] input_bytes размер входных массивов в байтах
 *  \param[in] ti_tics информация о тиках TI
 *  \return
 *      - \b int количество ошибок
 */
int test_mat_mul_cplx32(int32_t* src0, int32_t* src1, int32_t* dst_ref, int32_t* dst_opt, int rows0, int columns0,
                        int columns1, int print, int32_t shift, int32_t input_bytes, int32_t ti_tics);
/*!
 *  \fn int test_mat_mul_cplx_fl(float* src0, float* src1, float* dst_ref, float* dst_opt, int rows0, int columns0, int
 * columns1, int print, int32_t shift)
 *  \brief Тестирование функции комплексного умножения матриц mat_mul_cplx для типа float (cfloat)
 *  \param[in] src0 входные данные типа float (cfloat)
 *  \param[in] src1 входные данные типа float (cfloat)
 *  \param[out] dst_ref выходные данные типа float (cfloat) референсной функции
 *  \param[out] dst_opt выходные данные типа float (cfloat) ассемблерной функции
 *  \param[in] rows0 количество строк первой матрицы
 *  \param[in] columns0 количество столбцов первой матрицы
 *  \param[in] columns1 количество столбцов второй матрицы
 *  \param[in] print флаг для печати данных
 *  \param[in] shift сдвиг результата
 *  \param[in] input_bytes размер входных массивов в байтах
 *  \param[in] ti_tics информация о тиках TI
 *  \return
 *      - \b int количество ошибок
 */
int test_mat_mul_cplx_fl(float* src0, float* src1, float* dst_ref, float* dst_opt, int rows0, int columns0,
                         int columns1, int print, int32_t shift, int32_t input_bytes, int32_t ti_tics);
/*!
 *  \fn int test_mat_mul_cplx_db(double* src0, double* src1, double* dst_ref, double* dst_opt, int rows0, int columns0,
 * int columns1, int print, int32_t shift)
 *  \brief Тестирование функции комплексного умножения матриц mat_mul_cplx для типа double (cdouble)
 *  \param[in] src0 входные данные типа double (cdouble)
 *  \param[in] src1 входные данные типа double (cdouble)
 *  \param[out] dst_ref выходные данные типа double (cdouble) референсной функции
 *  \param[out] dst_opt выходные данные типа double (cdouble) ассемблерной функции
 *  \param[in] rows0 количество строк первой матрицы
 *  \param[in] columns0 количество столбцов первой матрицы
 *  \param[in] columns1 количество столбцов второй матрицы
 *  \param[in] print флаг для печати данных
 *  \param[in] shift сдвиг результата
 *  \param[in] input_bytes размер входных массивов в байтах
 *  \param[in] ti_tics информация о тиках TI
 *  \return
 *      - \b int количество ошибок
 */
int test_mat_mul_cplx_db(double* src0, double* src1, double* dst_ref, double* dst_opt, int rows0, int columns0,
                         int columns1, int print, int32_t shift, int32_t input_bytes, int32_t ti_tics);

/*!
 *  \fn int test_mat_trans_scalar(int16_t* src0, int16_t* dst_ref, int16_t* dst_opt, int rows, int columns, int print)
 *  \brief Тестирование функции транспонирования матриц mat_trans для типа double
 *  \param[in] src0 входные данные типа int16
 *  \param[out] dst_ref выходные данные типа int16 референсной функции
 *  \param[out] dst_opt выходные данные типа int16 ассемблерной функции
 *  \param[in] rows количество строк матрицы
 *  \param[in] columns количество столбцов матрицы
 *  \param[in] print флаг для печати данных
 *  \param[in] input_bytes размер входных массивов в байтах
 *  \param[in] ti_tics информация о тиках TI
 *  \return
 *      - \b int количество ошибок
 */
int test_mat_trans_scalar(int16_t* src0, int16_t* dst_ref, int16_t* dst_opt, int rows, int columns, int print,
                          int32_t input_bytes, int32_t ti_tics);
/*!
 *  \fn int test_mat_trans_scalar_s32(int32_t* src0, int32_t* dst_ref, int32_t* dst_opt, int rows, int columns, int
 * print)
 *  \brief Тестирование функции транспонирования матриц mat_trans для типа double
 *  \param[in] src0 входные данные типа int32
 *  \param[out] dst_ref выходные данные типа int32 референсной функции
 *  \param[out] dst_opt выходные данные типа int32 ассемблерной функции
 *  \param[in] rows количество строк матрицы
 *  \param[in] columns количество столбцов матрицы
 *  \param[in] print флаг для печати данных
 *  \param[in] input_bytes размер входных массивов в байтах
 *  \param[in] ti_tics информация о тиках TI
 *  \return
 *      - \b int количество ошибок
 */
int test_mat_trans_scalar_s32(int32_t* src0, int32_t* dst_ref, int32_t* dst_opt, int rows, int columns, int print,
                              int32_t input_bytes, int32_t ti_tics);
/*!
 *  \fn int test_mat_trans_scalar_fl(float* src0, float* dst_ref, float* dst_opt, int rows, int columns, int print)
 *  \brief Тестирование функции транспонирования матриц mat_trans для типа double
 *  \param[in] src0 входные данные типа float
 *  \param[out] dst_ref выходные данные типа float референсной функции
 *  \param[out] dst_opt выходные данные типа float ассемблерной функции
 *  \param[in] rows количество строк матрицы
 *  \param[in] columns количество столбцов матрицы
 *  \param[in] print флаг для печати данных
 *  \param[in] input_bytes размер входных массивов в байтах
 *  \param[in] ti_tics информация о тиках TI
 *  \return
 *      - \b int количество ошибок
 */
int test_mat_trans_scalar_fl(float* src0, float* dst_ref, float* dst_opt, int rows, int columns, int print,
                             int32_t input_bytes, int32_t ti_tics);
/*!
 *  \fn int test_mat_trans_scalar_db(double* src0, double* dst_ref, double* dst_opt, int rows, int columns, int print)
 *  \brief Тестирование функции транспонирования матриц mat_trans для типа double
 *  \param[in] src0 входные данные типа double
 *  \param[out] dst_ref выходные данные типа double референсной функции
 *  \param[out] dst_opt выходные данные типа double ассемблерной функции
 *  \param[in] rows количество строк матрицы
 *  \param[in] columns количество столбцов матрицы
 *  \param[in] print флаг для печати данных
 *  \param[in] input_bytes размер входных массивов в байтах
 *  \param[in] ti_tics информация о тиках TI
 *  \return
 *      - \b int количество ошибок
 */
int test_mat_trans_scalar_db(double* src0, double* dst_ref, double* dst_opt, int rows, int columns, int print,
                             int32_t input_bytes, int32_t ti_tics);

/// Тестирование функции mul16i16f
/// @return количество ошибок
int test_mul16i16f(int32_t* src0,        ///< [in]  входные данные первого массива
                   int32_t* src1,        ///< [in]  входные данные второго массива
                   int32_t* dst_opt,     ///< [out] выходные данные ассемблерной функции
                   int32_t* dst_ref,     ///< [out] выходные данные референсной функции
                   int size,             ///< [in]  количество элементов входных массивов
                   int print,            ///< [in]  флаг для печати данных
                   float rel_eps,        ///< [in]  относительная погрешность
                   int32_t input_bytes,  ///< [in]  размер входных массивов в байтах
                   int32_t ti_tics       ///< [in]  информация о тиках TI
);

/*!
 *  \fn int test_neg16(int16_t* src0, int16_t* dst_ref, int16_t* dst_opt, int size, int print)
 *  \brief Тестирование функции отрицания neg для типа int16
 *  \param[in] src0 входные данные типа int16
 *  \param[out] dst_ref выходные данные типа int16 референсной функции
 *  \param[out] dst_opt выходные данные типа int16 ассемблерной функции
 *  \param[in] size размер входного массива
 *  \param[in] print флаг для печати данных
 *  \param[in] input_bytes размер входных массивов в байтах
 *  \param[in] ti_tics информация о тиках TI
 *  \return
 *      - \b int количество ошибок
 */
int test_neg16(int16_t* src0, int16_t* dst_ref, int16_t* dst_opt, int size, int print, int32_t input_bytes,
               int32_t ti_tics);
/*!
 *  \fn int test_neg32(int32_t* src0, int32_t* dst_ref, int32_t* dst_opt, int size, int print)
 *  \brief Тестирование функции отрицания neg для типа int32
 *  \param[in] src0 входные данные типа int32
 *  \param[out] dst_ref выходные данные типа int32 референсной функции
 *  \param[out] dst_opt выходные данные типа int32 ассемблерной функции
 *  \param[in] size размер входного массива
 *  \param[in] print флаг для печати данных
 *  \param[in] input_bytes размер входных массивов в байтах
 *  \param[in] ti_tics информация о тиках TI
 *  \return
 *      - \b int количество ошибок
 */
int test_neg32(int32_t* src0, int32_t* dst_ref, int32_t* dst_opt, int size, int print, int32_t input_bytes,
               int32_t ti_tics);
/*!
 *  \fn int test_neg_fl(float* src0, float* dst_ref, float* dst_opt, int size, int print)
 *  \brief Тестирование функции отрицания neg для типа float
 *  \param[in] src0 входные данные типа float
 *  \param[out] dst_ref выходные данные типа float референсной функции
 *  \param[out] dst_opt выходные данные типа float ассемблерной функции
 *  \param[in] size размер входного массива
 *  \param[in] print флаг для печати данных
 *  \param[in] input_bytes размер входных массивов в байтах
 *  \param[in] ti_tics информация о тиках TI
 *  \return
 *      - \b int количество ошибок
 */
int test_neg_fl(float* src0, float* dst_ref, float* dst_opt, int size, int print, int32_t input_bytes,
                int32_t ti_tics);
/*!
 *  \fn int test_neg_db(double* src0, double* dst_ref, double* dst_opt, int size, int print)
 *  \brief Тестирование функции отрицания neg для типа double
 *  \param[in] src0 входные данные типа double
 *  \param[out] dst_ref выходные данные типа double референсной функции
 *  \param[out] dst_opt выходные данные типа double ассемблерной функции
 *  \param[in] size размер входного массива
 *  \param[in] print флаг для печати данных
 *  \param[in] input_bytes размер входных массивов в байтах
 *  \param[in] ti_tics информация о тиках TI
 *  \return
 *      - \b int количество ошибок
 */
int test_neg_db(double* src0, double* dst_ref, double* dst_opt, int size, int print, int32_t input_bytes,
                int32_t ti_tics);

/*!
 *  \fn int test_recip16(int16_t* src0, int16_t* res_rf, int16_t* res_exp, int16_t* dsp_res_rf, int16_t* dsp_res_exp,
 * int size, int print)
 *  \brief Тестирование recip16 для чисел с фиксированной точкой типа int16
 *  \param[in] src0 входные данные типа int16
 *  \param[out] res_rf выходные данные типа int16 референсной функции
 *  \param[out] res_exp выходные данные типа int16 референсной функции
 *  \param[out] dsp_res_rf выходные данные типа int16 ассемблерной функции
 *  \param[out] dsp_res_exp выходные данные типа int16 ассемблерной функции
 *  \param[in] size размер входных массивов
 *  \param[in] print флаг для печати данных
 *  \param[in] input_bytes размер входных массивов в байтах
 *  \param[in] ti_tics информация о тиках TI
 *  \return
 *      - \b int количество ошибок
 */
int test_recip16(int16_t* src0, int16_t* res_rf, int16_t* res_exp, int16_t* dsp_res_rf, int16_t* dsp_res_exp, int size,
                 int print, int32_t input_bytes, int32_t ti_tics);

/*!
 *  \fn int test_vecsumsq(int16_t* src0, int size, int print)
 *  \brief Тестирование функции взятия корня из суммы элементов массива vecsumsq для типа int16
 *  \param[in] src0 входные данные типа int16
 *  \param[in] size размер входных массивов
 *  \param[in] print флаг для печати данных
 *  \param[in] input_bytes размер входных массивов в байтах
 *  \param[in] ti_tics информация о тиках TI
 *  \return
 *      - \b int количество ошибок
 */
int test_vecsumsq(int16_t* src0, int size, int print, int32_t input_bytes, int32_t ti_tics);
/*!
 *  \fn int test_vecsumsq32(int32_t* src0, int size, int print)
 *  \brief Тестирование функции взятия корня из суммы элементов массива vecsumsq для типа int32
 *  \param[in] src0 входные данные типа int32
 *  \param[in] size размер входных массивов
 *  \param[in] print флаг для печати данных
 *  \param[in] input_bytes размер входных массивов в байтах
 *  \param[in] ti_tics информация о тиках TI
 *  \return
 *      - \b int количество ошибок
 */
int test_vecsumsq32(int32_t* src0, int size, int print, int32_t input_bytes, int32_t ti_tics);
/*!
 *  \fn int test_vecsumsq_fl(float* src0,int size, int print)
 *  \brief Тестирование функции взятия корня из суммы элементов массива vecsumsq для типа float
 *  \param[in] src0 входные данные типа float
 *  \param[in] size размер входных массивов
 *  \param[in] print флаг для печати данных
 *  \param[in] input_bytes размер входных массивов в байтах
 *  \param[in] ti_tics информация о тиках TI
 *  \return
 *      - \b int количество ошибок
 */
int test_vecsumsq_fl(float* src0, int size, int print, int32_t input_bytes, int32_t ti_tics);
/*!
 *  \fn int test_vecsumsq_db(double* src0, int size, int print)
 *  \brief Тестирование функции взятия корня из суммы элементов массива vecsumsq для типа double
 *  \param[in] src0 входные данные типа double
 *  \param[in] size размер входных массивов
 *  \param[in] print флаг для печати данных
 *  \param[in] input_bytes размер входных массивов в байтах
 *  \param[in] ti_tics информация о тиках TI
 *  \return
 *      - \b int количество ошибок
 */
int test_vecsumsq_db(double* src0, int size, int print, int32_t input_bytes, int32_t ti_tics);

/*!
 *  \fn int test_w_vec(int16_t* src0, int16_t* src1, int16_t* dst_ref, int16_t* dst_opt, int size, int print, int16_t
 * w)
 *  \brief Тестирование функции w_vec для типа int16
 *  \param[in] src0 входные данные типа int16
 *  \param[in] src1 входные данные типа int16
 *  \param[out] dst_ref выходные данные типа int16 референсной функции
 *  \param[out] dst_opt выходные данные типа int16 ассемблерной функции
 *  \param[in] size размер входных массивов
 *  \param[in] print флаг для печати данных
 *  \param[in] w коэффициент для умножения элементов второго массива
 *  \param[in] input_bytes размер входных массивов в байтах
 *  \param[in] ti_tics информация о тиках TI
 *  \return
 *      - \b int количество ошибок
 */
int test_w_vec(int16_t* src0, int16_t* src1, int16_t* dst_ref, int16_t* dst_opt, int size, int print, int16_t w,
               int32_t input_bytes, int32_t ti_tics);
/*!
 *  \fn int test_w_vec32(int32_t* src0, int32_t* src1, int32_t* dst_ref, int32_t* dst_opt, int size, int print, int32_t
 * w)
 *  \brief Тестирование функции w_vec для типа int32
 *  \param[in] src0 входные данные типа int32
 *  \param[in] src1 входные данные типа int32
 *  \param[out] dst_ref выходные данные типа int32 референсной функции
 *  \param[out] dst_opt выходные данные типа int32 ассемблерной функции
 *  \param[in] size размер входных массивов
 *  \param[in] print флаг для печати данных
 *  \param[in] w коэффициент для умножения элементов второго массива
 *  \param[in] input_bytes размер входных массивов в байтах
 *  \param[in] ti_tics информация о тиках TI
 *  \return
 *      - \b int количество ошибок
 */
int test_w_vec32(int32_t* src0, int32_t* src1, int32_t* dst_ref, int32_t* dst_opt, int size, int print, int32_t w,
                 int32_t input_bytes, int32_t ti_tics);
/*!
 *  \fn int test_w_vec_fl(float* src0, float* src1, float* dst_ref, float* dst_opt, int size, int print, float w)
 *  \brief Тестирование функции w_vec для типа float
 *  \param[in] src0 входные данные типа float
 *  \param[in] src1 входные данные типа float
 *  \param[out] dst_ref выходные данные типа float референсной функции
 *  \param[out] dst_opt выходные данные типа float ассемблерной функции
 *  \param[in] size размер входных массивов
 *  \param[in] print флаг для печати данных
 *  \param[in] w коэффициент для умножения элементов второго массива
 *  \param[in] input_bytes размер входных массивов в байтах
 *  \param[in] ti_tics информация о тиках TI
 *  \return
 *      - \b int количество ошибок
 */
int test_w_vec_fl(float* src0, float* src1, float* dst_ref, float* dst_opt, int size, int print, float w,
                  int32_t input_bytes, int32_t ti_tics);
/*!
 *  \fn int test_w_vec_db(double* src0, double* src1, double* dst_ref, double* dst_opt, int size, int print, double w)
 *  \brief Тестирование функции w_vec для типа double
 *  \param[in] src0 входные данные типа double
 *  \param[in] src1 входные данные типа double
 *  \param[out] dst_ref выходные данные типа double референсной функции
 *  \param[out] dst_opt выходные данные типа double ассемблерной функции
 *  \param[in] size размер входных массивов
 *  \param[in] print флаг для печати данных
 *  \param[in] w коэффициент для умножения элементов второго массива
 *  \param[in] input_bytes размер входных массивов в байтах
 *  \param[in] ti_tics информация о тиках TI
 *  \return
 *      - \b int количество ошибок
 */
int test_w_vec_db(double* src0, double* src1, double* dst_ref, double* dst_opt, int size, int print, double w,
                  int32_t input_bytes, int32_t ti_tics);
