// Copyright 2025 RnD Center "ELVEES", JSC

#ifndef COMMON_H
#define COMMON_H

#include <stdint.h>
#include <stdio.h>
#include <string.h>

#include <cassert>

#include "elcore50-matrix-lib/dmainit.h"

enum Store_version {
  STORE_NONE,
  STORE_RELU,
  STORE_RELU6,
};

typedef struct Tensor_fl32 {
  float *data;
  int batch, height, width, channel;
} Tensor_fl32;

typedef struct Tensor_fl16 {
  uint16_t *data;
  int batch, height, width, channel;
} Tensor_fl16;

typedef struct Weight_fl32 {
  float *data;
  int kernelX, kernelY, srcC, dstC;
  int strideX, strideY, dilationX, dilationY;
} Weight_fl32;

typedef struct Weight_fl16 {
  uint16_t *data;
  int kernelX, kernelY, srcC, dstC;
  int strideX, strideY, dilationX, dilationY;
} Weight_fl16;

typedef struct LocalMemBufFl16 {
  uint16_t *buf_A[2], *buf_B[2], *buf_C[2];
  float *buf_init_vec;
  int buf_row0, buf_row1col0, buf_col1;
} LocalMemBufFl16;

typedef struct ConvLocalMemBufFl16 {
  uint16_t *buf_A[2], *buf_B[2], *buf_C[2];
  uint16_t *ones;
  float *buf_init_vec;
  int buf_srcH, buf_srcW, buf_srcC, buf_dstH, buf_dstW, buf_dstC, offset_A;
  int tile_padX, tile_padY, tile_padW, tile_padH;
} ConvLocalMemBufFl16;

typedef struct MatMulDmaChains4 {
  VDMAChain *chain_A;
  VDMAChain *chain_B;
  VDMAChain *chain_ld_C;
  VDMAChain *chain_st_C;
  VDMAChain *chain_init_vec;
  int len_chain_A;
  int len_chain_B;
  int len_chain_ld_C;
  int len_chain_st_C;
} MatMulDmaChains4;

#endif
