// Copyright 2024-2025 RnD Center "ELVEES", JSC

/*! \file
 *  \brief Заголовочный файл для параметризации тестов тайловой сегментации
 *  \author Фролов Андрей
 */

#ifndef TESTS_TILE_SEGMENTATION
#define TESTS_TILE_SEGMENTATION

#include <elcore50-dsplib/calculation_runners.hpp>
#include <elcore50-dsplib/dma_chain_creators.hpp>
#include <elcore50-dsplib/tile_segmentation.hpp>
#include <iostream>

extern "C" {
#include <elcore50-dsplib/elcore50.h>
#include <elcore50-dsplib/reference.h>

#include "helper.h"
}

//! Максимальный размер входного массива
const int SIZE = MAX_TEST_SIZE;

/*! Параметр выбора реализации функции для сравнения с версией с тайловой
    сегментацией. USE_REF_VER - используется референсная версия на С.
    Если параметр не определен, то используется версия на asm.*/
#define USE_REF_VER

/*!
 *  \fn void data_generator(T* dst, size_t size, int min_value, int max_value)
 *  \brief Простейший генератор данных в диапазоне (min_value, max_value)
 *  \param[out] dst указатель выходной массив
 *  \param[in] size размер выходного массива
 *  \param[in] min_value минимальный элемент генерируемого диапазона
 *  \param[in] max_value максимальный элемент генерируемого диапазона
 */
template <class T>
void data_generator(T* dst, size_t size, int min_value, int max_value) {
  if (!dst) {
    std::cout << "WARNING! data_generator: NULL ptr" << std::endl;
    return;
  }

  if (max_value < min_value) std::swap(min_value, max_value);

  for (int i = 0; i < size; ++i) {
    dst[i] = min_value + (rand() % (max_value - min_value));
  }
}

#endif
