ENTRY(___start)
OUTPUT_ARCH("elcore32")

GROUP(-lc++ -lc++abi -lunwind -lpyapi -lm -lc -lcrt)

SECTIONS {

 . = 0x80000000;

 .text :
  {
    _stext = .;
    *.*(.text);
    . = ALIGN (32 / 8);
    _etext = .;
  }

 .eh_frame :
  {
    ___eh_frame_start = . ;
    *.*(.eh_frame);
    . = ALIGN (32 / 8);
  }
  ___eh_frame_end = . ;

  . = 0x90000000;

 .data :
  {
    *.*(.data);
  /* Constructor and destructor tables are in ROM.  */
     ___CTOR_LIST__ = .;
     KEEP (*(.ctors .ctors.*))
     ___CTOR_END__ = .;
     ___DTOR_LIST__ = .;
     KEEP (*(.dtors dtors.*))
     ___DTOR_END__ = .;
    *.*(.rodata .rodata.*);
    *.*(.data.rel .data.rel.*);
    . = ALIGN (32 / 8);
  }

 .bss :
  {
    ___bss_start = . ;
    *(.sbss)
    *(.bss .bss.*);
    . = ALIGN (32 / 8);
  }
  ___bss_end = . ;

 .heap :
  {
    PROVIDE(__end = ALIGN(0x10000));

    . += 0x08000000;
    PROVIDE(___stack = ALIGN(8));
  }
}
