// Copyright 2025 RnD Center "ELVEES", JSC

#ifndef ARGPARSER_H
#define ARGPARSER_H

//! Максимальное количество имен файлов в командной строке
#define MAX_FILES 100

/// Печать информации об использовании функции argparser
void argparser_print_usage();
/// Получение имен входных и выходных файлов из аргументов командной строки
/// @return количество считанных имен
int8_t argparser(int argc,          ///< [in] количество аргументов командной строки
                 char* argv[],      ///< [in] аргументы командной строки
                 char *infiles[],   ///< [out] имена файлов с входными данными
                 char *outfiles[]   ///< [out] имена файлов с референсными данными
);
/// Чтение данных из бинарного файла
/// @return true=success, false=error
int8_t read_data_from_file(float *src,            ///< [out] массив с данными из файла
                           const int32_t size,    ///< [in] количество элементов в файле
                           const char *filename   ///< [in] имя файла
);

#endif
