# Copyright 2024 RnD Center "ELVEES", JSC

import os
import pytest
import subprocess


@pytest.mark.parametrize(
    "dim, rows, cols",
    [
        pytest.param("1d", 1, 256),
        pytest.param("1d", 1, 4096),
        pytest.param("1d", 1, 131072),
        pytest.param("2d", 64, 64),
        pytest.param("2d", 256, 512),
        pytest.param("2d", 512, 256),
    ],
)
def test_sample_fft_all(dim, cols, rows):
    data_types_list = ["float16", "float32", "fract16"]
    binary_path = os.path.join(os.path.dirname(__file__) + "/elf/sample-fft-all.elf")
    for data_type in data_types_list:
        for mem_type in range(2):
            subprocess.run(
                [
                    "elcorecl-run",
                    "-e",
                    binary_path,
                    "--",
                    dim,
                    data_type,
                    "-r",
                    str(rows),
                    "-c",
                    str(cols),
                    "-m",
                    str(mem_type),
                ],
                check=True,
                timeout=100,
            )
