// Copyright 2025 RnD Center "ELVEES", JSC

#ifndef TILE_SEGMENTATION_H
#define TILE_SEGMENTATION_H

#include <stdint.h>

#include <cmath>
#include <iostream>

#include "elcore50-matrix-lib/dmainit.h"

/// Cтруктура для параметризации запуска функции с тайловой сегментацией.
/// Используются в общем случае четыре цепочки DMA. По две на входные и выходные
/// данные.
typedef struct TileSegConfig {
  TileSegConfig();
  ~TileSegConfig();
  VDMAChain* chain0;  ///< указатель на цепочку 0
  VDMAChain* chain1;  ///< указатель на цепочку 1
  VDMAChain* chain2;  ///< указатель на цепочку 2
  VDMAChain* chain3;  ///< указатель на цепочку 3
  int chain0_length;  ///< длина цепочки 0
  int chain1_length;  ///< длина цепочки 1
  int chain2_length;  ///< длина цепочки 2
  int chain3_length;  ///< длина цепочки 3

  int32_t* func_params0;   ///< указатель на параметры функции (пр. длины каждого
                           ///< из тайлов)
  int32_t* func_params1;   ///< указатель на параметры функции (пр. длины каждого
                           ///< из тайлов)
  int32_t* func_params2;   ///< указатель на параметры функции (пр. длины каждого
                           ///< из тайлов)
  int32_t* func_params3;   ///< указатель на параметры функции (пр. длины каждого
                           ///< из тайлов)
  int func_params_length;  ///< к-во элементов func_params

  uint16_t* ptr_zeros;  ///< указатель на вспомогательный массив нолей для заполнения паддингов

  uint16_t* ptr_src_buf[2];  ///< указатели на буферы во внут. памяти для
                             ///< входных данных
  uint16_t* ptr_dst_buf[2];  ///< указатели на буферы во внут. памяти для
                             ///< выходных данных

  size_t dst_tile_ch, dst_tile_h,
      dst_tile_w;  ///< размеры тайла входного для output transform
  size_t src_tile_ch, src_tile_h,
      src_tile_w;  ///< размеры тайла входного для input transform

 private:
  TileSegConfig(const TileSegConfig&);
  TileSegConfig& operator=(const TileSegConfig&);
} TileSegConfig;

/// Функция для начальной инициализации структуры TileSegConfig
void CreateTileSegConfig(TileSegConfig* config  ///< [in/out] указатель на структуру для параметризации запуска
);

/// Функция для очистки параметров структуры TileSegConfig
void DestroyTileSegConfig(TileSegConfig* config  ///< [in/out] указатель на структуру для параметризации запуска
);

#endif
