// Copyright 2025 RnD Center "ELVEES", JSC

/*! \file
 *  \brief Тестирование одномерного БПФ
 *
 * При тестировании поочередно вычисляется БПФ от сигнала минимального размера fft_min_size
 * до максимального размера fft_max_size
 */

#include "test.h"

int main() {
  printf("\nstart test ");

  sl_data_types test_format = (sl_data_types)FORMAT;
  sl_transform_type test_type = (sl_transform_type)TRANSFORM_TYPES;

  const int fft_min_size = 256;
  const int fft_max_size = MAX_SIZE;

  int test_err = 0;

  switch (test_format) {
    case SL_FLOAT:
      if (test_type == SL_FFT)
        test_err = test_fft_float_1d(fft_min_size, fft_max_size);
      else
        test_err = test_ifft_float_1d(fft_min_size, fft_max_size);
      break;
    case SL_HFLOAT:
      if (test_type == SL_FFT)
        test_err = test_fft_hfloat_1d(fft_min_size, fft_max_size);
      else
        test_err = test_ifft_hfloat_1d(fft_min_size, fft_max_size);
      break;
    case SL_FRACTIONAL:
      if (test_type == SL_FFT)
        test_err = test_fft_fract_1d(fft_min_size, fft_max_size);
      else
        test_err = test_ifft_fract_1d(fft_min_size, fft_max_size);
      break;
  }

  return test_err;
}
