// Copyright 2025 RnD Center "ELVEES", JSC

#ifndef _GST_FELIX_META_H_
#define _GST_FELIX_META_H_

#include <stdint.h>

#include <gst/gst.h>

G_BEGIN_DECLS

/**
 * Current brightness metadata
*/
#define GST_FELIX_CURRENT_BRIGHTNESS_META_API_TYPE (gst_felix_current_brightness_meta_api_get_type())
#define GST_FELIX_CURRENT_BRIGHTNESS_META_INFO     (gst_felix_current_brightness_meta_get_info())

typedef struct _GstFelixCurrentBrightnessMeta GstFelixCurrentBrightnessMeta;

struct _GstFelixCurrentBrightnessMeta
{
    GstMeta meta;

    gfloat current_brightness;
};

GType gst_felix_current_brightness_meta_api_get_type (void);

GST_EXPORT
const GstMetaInfo * gst_felix_current_brightness_meta_get_info (void);

GST_EXPORT
GstFelixCurrentBrightnessMeta * gst_buffer_add_current_brightness_meta (GstBuffer * buffer,
  gfloat current_brightness);

/**
 * Brightness histograms metadata
*/
#define HIS_GLOBAL_BINS 64
#define HIS_REGION_BINS 16
#define HIS_REGION_HTILES 7
#define HIS_REGION_VTILES 7

typedef struct BrightnessHist
{
    /** @brief A single global histogram  */
    uint32_t globalHistogram[HIS_GLOBAL_BINS];
    /** @brief Region HistogramsAn array of width*height histograms with nbins each */
    uint32_t regionHistograms[HIS_REGION_VTILES][HIS_REGION_HTILES][HIS_REGION_BINS];
} BrightnessHist;

#define GST_FELIX_BRIGHTNESS_HIST_META_API_TYPE (gst_felix_brightness_hist_meta_api_get_type())
#define GST_FELIX_BRIGHTNESS_HIST_META_INFO     (gst_felix_brightness_hist_meta_get_info())

typedef struct _GstFelixBrightnessHistMeta GstFelixBrightnessHistMeta;

struct _GstFelixBrightnessHistMeta
{
    GstMeta meta;

    BrightnessHist brightness_hist;
};

GType gst_felix_brightness_hist_meta_api_get_type (void);

GST_EXPORT
const GstMetaInfo * gst_felix_brightness_hist_meta_get_info (void);

GST_EXPORT
GstFelixBrightnessHistMeta * gst_buffer_add_brightness_hist_meta (GstBuffer * buffer,
  BrightnessHist *hist);

G_END_DECLS

#endif /* _GST_FELIX_META_H_ */
