/*************************************************************************/ /*!
@File
@Title          EGL extensions.
@Copyright      Copyright (c) Imagination Technologies Ltd. All Rights Reserved
@License        Strictly Confidential.
*/ /**************************************************************************/

#ifndef __drv_eglext_h__
#define __drv_eglext_h__

/* We want all the prototypes */
#define EGL_EGLEXT_PROTOTYPES

/* NOTE: If you want to override an extension, you could put it here,
 * before we include the Khronos header, so the khronos header doesn't
 * define it first.
 */

/* Include the Khronos header first */
#include <EGL/eglext.h>

/* NOTE: Extensions following might be overridden by the platform's
 * version of eglext.h. For example, EGL_ANDROID_blob_cache will
 * already be defined by this point for Android, but not Linux.
 */

#ifndef EGL_IMG_cl_image
#define EGL_IMG_cl_image 1
#define EGL_CL_IMAGE_IMG						0x6010  /* experimental eglCreateImageKHR target */
#endif

#ifndef EGL_IMG_rl_image
#define EGL_IMG_rl_image 1
#define EGL_RL_TEXTURE_2D_IMG					0x6011  /* experimental eglCreateImageKHR target */
#endif


#ifndef EGL_KHR_gl_colorspace
#define EGL_GL_COLORSPACE_KHR								0x309D
#define EGL_GL_COLORSPACE_SRGB_KHR							0x3089
#define EGL_GL_COLORSPACE_LINEAR_KHR						0x308A
#endif

#define EGL_OPENRL_API_IMG									0x30A3
#define EGL_CONTEXT_OPENRL_ATTRIBUTE_IMG					0x30A4
#define EGL_OPENRL_BIT_IMG									0x00000080

#ifndef EGL_IMG_image_plane_attribs
#define EGL_IMG_image_plane_attribs 1
#define EGL_NATIVE_BUFFER_MULTIPLANE_SEPARATE_IMG 0x3105
#define EGL_NATIVE_BUFFER_PLANE_OFFSET_IMG        0x3106
#endif

#ifndef EGL_IMG_image_debug_dump
#define EGL_IMG_image_debug_dump 1

typedef void (EGLAPIENTRYP IMAGEDUMPCALLBACKPROC) (const void *userParam, EGLenum target, EGLImageKHR image, EGLClientBuffer buffer);

typedef EGLBoolean (EGLAPIENTRYP PFNEGLIMAGEDUMPCALLBACKPROC) (EGLDisplay dpy, EGLContext ctx, IMAGEDUMPCALLBACKPROC callback, const void *userParam);

#if defined(EGL_EGLEXT_PROTOTYPES)
EGLAPI EGLBoolean EGLAPIENTRY eglImageDumpCallbackIMG (EGLDisplay dpy, EGLContext ctx, IMAGEDUMPCALLBACKPROC callback, const void *userParam);
#endif
#endif

#if defined(EGL_EXTENSION_MUTABLE_RENDER_BUFFER)
#ifndef EGL_MUTABLE_RENDER_BUFFER_BIT_KHR 
#define EGL_MUTABLE_RENDER_BUFFER_BIT_KHR 0x00001000
#endif
#endif /* defined(EGL_EXTENSION_MUTABLE_RENDER_BUFFER) */

#if defined(EGL_EXTENSION_CONTENT_PROTECTED)
#ifndef EGL_PROTECTED_CONTENT_EXT 
#define EGL_PROTECTED_CONTENT_EXT 0x32C0
#endif
#endif /* defined(EGL_EXTENSION_CONTENT_PROTECTED) */

#ifndef EGL_EXT_yuv_surface
#define EGL_EXT_yuv_surface 1
#define EGL_YUV_ORDER_EXT                 0x3301
#define EGL_YUV_NUMBER_OF_PLANES_EXT      0x3311
#define EGL_YUV_SUBSAMPLE_EXT             0x3312
#define EGL_YUV_DEPTH_RANGE_EXT           0x3317
#define EGL_YUV_CSC_STANDARD_EXT          0x330A
#define EGL_YUV_PLANE_BPP_EXT             0x331A
#define EGL_YUV_BUFFER_EXT                0x3300
#define EGL_YUV_ORDER_YUV_EXT             0x3302
#define EGL_YUV_ORDER_YVU_EXT             0x3303
#define EGL_YUV_ORDER_YUYV_EXT            0x3304
#define EGL_YUV_ORDER_UYVY_EXT            0x3305
#define EGL_YUV_ORDER_YVYU_EXT            0x3306
#define EGL_YUV_ORDER_VYUY_EXT            0x3307
#define EGL_YUV_ORDER_AYUV_EXT            0x3308
#define EGL_YUV_SUBSAMPLE_4_2_0_EXT       0x3313
#define EGL_YUV_SUBSAMPLE_4_2_2_EXT       0x3314
#define EGL_YUV_SUBSAMPLE_4_4_4_EXT       0x3315
#define EGL_YUV_DEPTH_RANGE_LIMITED_EXT   0x3318
#define EGL_YUV_DEPTH_RANGE_FULL_EXT      0x3319
#define EGL_YUV_CSC_STANDARD_601_EXT      0x330B
#define EGL_YUV_CSC_STANDARD_709_EXT      0x330C
#define EGL_YUV_CSC_STANDARD_2020_EXT     0x330D
#define EGL_YUV_PLANE_BPP_0_EXT           0x331B
#define EGL_YUV_PLANE_BPP_8_EXT           0x331C
#define EGL_YUV_PLANE_BPP_10_EXT          0x331D
#endif /* EGL_EXT_yuv_surface */

#ifndef EGL_EXT_gl_colorspace_scrgb_linear
#define EGL_EXT_gl_colorspace_scrgb_linear 1
#define EGL_GL_COLORSPACE_SCRGB_LINEAR_EXT 0x3350
#endif /* EGL_EXT_gl_colorspace_scrgb_linear */

#ifndef EGL_EXT_gl_colorspace_display_p3
#define EGL_EXT_gl_colorspace_display_p3 1
#define EGL_GL_COLORSPACE_DISPLAY_P3_EXT  0x3363
#endif /* EGL_EXT_gl_colorspace_display_p3 */

#ifndef EGL_EXT_gl_colorspace_display_p3_linear
#define EGL_EXT_gl_colorspace_display_p3_linear 1
#define EGL_GL_COLORSPACE_DISPLAY_P3_LINEAR_EXT 0x3362
#endif /* EGL_EXT_gl_colorspace_display_p3_linear */

#endif /* __drv_eglext_h__ */
